/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.rollable.expression;

import com.iafenvoy.rollable.expression.Expression;
import com.iafenvoy.rollable.expression.Parser;
import java.util.ArrayList;
import java.util.Random;

public class ExpressionParser
extends Parser {
    private static final Random RANDOM = new Random();
    private Expression compiled;
    private RuntimeException error;

    public static Expression parse(String string) {
        return new ExpressionParser(string).build();
    }

    public ExpressionParser(String string) {
        super(string);
    }

    public Expression getCompiled() {
        if (this.compiled == null && this.error == null) {
            try {
                return this.build();
            }
            catch (RuntimeException e) {
                this.error = e;
                return null;
            }
        }
        return this.compiled;
    }

    public Expression getCompiledOrDefaulting(double defaultValue) {
        return this.hasError() ? vars -> defaultValue : this.getCompiled();
    }

    public RuntimeException getError() {
        this.getCompiled();
        return this.error;
    }

    public boolean hasError() {
        this.getCompiled();
        return this.error != null;
    }

    public Expression build() {
        this.nextChar();
        Expression x = this.parseExpression();
        if (this.pos < this.string.length()) {
            throw new RuntimeException("Unexpected character '" + this.ch + "' at position " + this.pos);
        }
        this.compiled = x;
        return x;
    }

    private Expression parseExpression() {
        Expression x = this.parseTerm();
        while (true) {
            Expression b;
            Expression a;
            if (this.weat('+')) {
                a = x;
                b = this.parseTerm();
                x = vars -> a.eval(vars) + b.eval(vars);
                continue;
            }
            if (!this.weat('-')) break;
            a = x;
            b = this.parseTerm();
            x = vars -> a.eval(vars) - b.eval(vars);
        }
        return x;
    }

    private Expression parseTerm() {
        Expression x = this.parseFactor();
        while (true) {
            Expression b;
            Expression a;
            if (this.weat('*')) {
                a = x;
                b = this.parseFactor();
                x = vars -> a.eval(vars) * b.eval(vars);
                continue;
            }
            if (!this.weat('/')) break;
            a = x;
            b = this.parseFactor();
            x = vars -> a.eval(vars) / b.eval(vars);
        }
        return x;
    }

    private Expression parseFactor() {
        Expression x;
        if (this.weat('+')) {
            Expression a = this.parseFactor();
            return vars -> a.eval(vars);
        }
        if (this.weat('-')) {
            Expression a = this.parseFactor();
            return vars -> -a.eval(vars);
        }
        int startPos = this.pos;
        if (this.weat('(')) {
            x = this.parseExpression();
            if (!this.weat(')')) {
                throw new RuntimeException("Missing ')' at position " + this.pos);
            }
        } else if (this.ch >= '0' && this.ch <= '9' || this.ch == '.') {
            while (this.ch >= '0' && this.ch <= '9' || this.ch == '.') {
                this.nextChar();
            }
            double a = Double.parseDouble(this.string.substring(startPos, this.pos));
            x = vars -> a;
        } else if (this.isVariableChar()) {
            while (this.isVariableChar()) {
                this.nextChar();
            }
            String name = this.string.substring(startPos, this.pos);
            ArrayList<Expression> args = new ArrayList<Expression>();
            if (this.weat('(')) {
                do {
                    args.add(this.parseExpression());
                } while (this.weat(','));
                if (!this.weat(')')) {
                    throw new RuntimeException("Missing ')' after argument to '" + name + "'");
                }
                x = switch (args.size()) {
                    case 1 -> {
                        Expression a = (Expression)args.get(0);
                        switch (name) {
                            case "sqrt": {
                                yield vars -> Math.sqrt(a.eval(vars));
                            }
                            case "sin": {
                                yield vars -> Math.sin(a.eval(vars));
                            }
                            case "cos": {
                                yield vars -> Math.cos(a.eval(vars));
                            }
                            case "tan": {
                                yield vars -> Math.tan(a.eval(vars));
                            }
                            case "asin": {
                                yield vars -> Math.asin(a.eval(vars));
                            }
                            case "acos": {
                                yield vars -> Math.acos(a.eval(vars));
                            }
                            case "atan": {
                                yield vars -> Math.atan(a.eval(vars));
                            }
                            case "abs": {
                                yield vars -> Math.abs(a.eval(vars));
                            }
                            case "ceil": {
                                yield vars -> Math.ceil(a.eval(vars));
                            }
                            case "floor": {
                                yield vars -> Math.floor(a.eval(vars));
                            }
                            case "log": {
                                yield vars -> Math.log(a.eval(vars));
                            }
                            case "round": {
                                yield vars -> Math.round(a.eval(vars));
                            }
                            case "randint": {
                                yield vars -> RANDOM.nextInt((int)a.eval(vars));
                            }
                        }
                        throw new RuntimeException("Unknown function '" + name + "' for 1 arg at position " + (this.pos - name.length()));
                    }
                    case 2 -> {
                        Expression a = (Expression)args.get(0);
                        Expression b = (Expression)args.get(1);
                        switch (name) {
                            case "min": {
                                yield vars -> Math.min(a.eval(vars), b.eval(vars));
                            }
                            case "max": {
                                yield vars -> Math.max(a.eval(vars), b.eval(vars));
                            }
                            case "randint": {
                                yield vars -> {
                                    double av = a.eval(vars);
                                    return av + (double)RANDOM.nextInt((int)(b.eval(vars) - av));
                                };
                            }
                        }
                        throw new RuntimeException("Unknown function '" + name + "' for 2 args at position " + (this.pos - name.length()));
                    }
                    default -> throw new RuntimeException("Unknown function '" + name + "' for " + args.size() + " args at position " + (this.pos - name.length()));
                };
            } else {
                double a = switch (name) {
                    case "PI" -> Math.PI;
                    case "E" -> Math.E;
                    case "TO_RAD" -> Math.PI / 180;
                    case "TO_DEG" -> 57.29577951308232;
                    default -> throw new RuntimeException("Unknown constant '" + name + "' at position " + (this.pos - name.length()));
                };
                x = vars -> a;
            }
        } else if (this.weat('$')) {
            while (this.isVariableChar()) {
                this.nextChar();
            }
            String variable = this.string.substring(startPos + 1, this.pos);
            x = vars -> {
                Double value = (Double)vars.get(variable);
                return value != null ? value : 0.0;
            };
        } else {
            throw new RuntimeException("Unexpected '" + this.ch + "' at position " + this.pos);
        }
        if (this.weat('^')) {
            Expression a = x;
            Expression b = this.parseFactor();
            x = vars -> Math.pow(a.eval(vars), b.eval(vars));
        }
        return x;
    }
}

