/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.rollable.fabric.compat;

import com.iafenvoy.rollable.Rollable;
import com.iafenvoy.rollable.RollableKeybindings;
import com.iafenvoy.rollable.config.RollableClientConfig;
import com.iafenvoy.rollable.event.ClientEvents;
import com.iafenvoy.rollable.flight.RollContext;
import com.iafenvoy.rollable.flight.RollProcessGroup;
import com.iafenvoy.rollable.flight.RotateState;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.api.entrypoint.ControlifyEntrypoint;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.controller.ControllerEntity;
import java.util.Optional;
import net.minecraft.class_2561;

public class Controlify
implements ControlifyEntrypoint {
    public static final BindContext FALL_FLYING = new BindContext(Rollable.id("fall_flying"), client -> ClientEvents.isFallFlying());
    public static InputBindingSupplier PITCH_UP;
    public static InputBindingSupplier PITCH_DOWN;
    public static InputBindingSupplier ROLL_LEFT;
    public static InputBindingSupplier ROLL_RIGHT;
    public static InputBindingSupplier YAW_LEFT;
    public static InputBindingSupplier YAW_RIGHT;

    private RotateState applyToRotation(RotateState rotationDelta, RollContext context) {
        Optional perhapsController = ControlifyApi.get().getCurrentController();
        if (perhapsController.isPresent()) {
            ControllerEntity controller = (ControllerEntity)perhapsController.get();
            RotateState sensitivity = (RotateState)RollableClientConfig.INSTANCE.sensitivity.controller.getValue();
            if (PITCH_UP.on(controller) == null) {
                return rotationDelta;
            }
            double multiplier = context.getRenderDelta() * 1200.0;
            double pitchAxis = PITCH_DOWN.on(controller).analogueNow() - PITCH_UP.on(controller).analogueNow();
            double yawAxis = YAW_RIGHT.on(controller).analogueNow() - YAW_LEFT.on(controller).analogueNow();
            double rollAxis = ROLL_RIGHT.on(controller).analogueNow() - ROLL_LEFT.on(controller).analogueNow();
            return rotationDelta.add(pitchAxis *= multiplier * sensitivity.pitch(), yawAxis *= multiplier * sensitivity.yaw(), rollAxis *= multiplier * sensitivity.roll());
        }
        return rotationDelta;
    }

    public void onControlifyInit(ControlifyApi controlifyApi) {
        ControlifyBindApi bindings = ControlifyBindApi.get();
        bindings.registerBindContext(FALL_FLYING);
        PITCH_UP = bindings.registerBinding(builder -> builder.id(Rollable.id("pitch_up")).category((class_2561)class_2561.method_43471((String)RollableKeybindings.PITCH_UP.method_1423())).name((class_2561)class_2561.method_43471((String)RollableKeybindings.PITCH_UP.method_1431())).allowedContexts(new BindContext[]{FALL_FLYING, BindContext.IN_GAME}).addKeyCorrelation(RollableKeybindings.PITCH_UP));
        PITCH_DOWN = bindings.registerBinding(builder -> builder.id(Rollable.id("pitch_down")).category((class_2561)class_2561.method_43471((String)RollableKeybindings.PITCH_DOWN.method_1423())).name((class_2561)class_2561.method_43471((String)RollableKeybindings.PITCH_DOWN.method_1431())).allowedContexts(new BindContext[]{FALL_FLYING, BindContext.IN_GAME}).addKeyCorrelation(RollableKeybindings.PITCH_DOWN));
        ROLL_LEFT = bindings.registerBinding(builder -> builder.id(Rollable.id("roll_left")).category((class_2561)class_2561.method_43471((String)RollableKeybindings.ROLL_LEFT.method_1423())).name((class_2561)class_2561.method_43471((String)RollableKeybindings.ROLL_LEFT.method_1431())).allowedContexts(new BindContext[]{FALL_FLYING, BindContext.IN_GAME}).addKeyCorrelation(RollableKeybindings.ROLL_LEFT));
        ROLL_RIGHT = bindings.registerBinding(builder -> builder.id(Rollable.id("roll_right")).category((class_2561)class_2561.method_43471((String)RollableKeybindings.ROLL_RIGHT.method_1423())).name((class_2561)class_2561.method_43471((String)RollableKeybindings.ROLL_RIGHT.method_1431())).allowedContexts(new BindContext[]{FALL_FLYING, BindContext.IN_GAME}).addKeyCorrelation(RollableKeybindings.ROLL_RIGHT));
        YAW_LEFT = bindings.registerBinding(builder -> builder.id(Rollable.id("yaw_left")).category((class_2561)class_2561.method_43471((String)RollableKeybindings.YAW_LEFT.method_1423())).name((class_2561)class_2561.method_43471((String)RollableKeybindings.YAW_LEFT.method_1431())).allowedContexts(new BindContext[]{FALL_FLYING, BindContext.IN_GAME}).addKeyCorrelation(RollableKeybindings.YAW_LEFT));
        YAW_RIGHT = bindings.registerBinding(builder -> builder.id(Rollable.id("yaw_right")).category((class_2561)class_2561.method_43471((String)RollableKeybindings.YAW_RIGHT.method_1423())).name((class_2561)class_2561.method_43471((String)RollableKeybindings.YAW_RIGHT.method_1431())).allowedContexts(new BindContext[]{FALL_FLYING, BindContext.IN_GAME}).addKeyCorrelation(RollableKeybindings.YAW_RIGHT));
        RollProcessGroup.get(Rollable.id("elytra")).registerAfterModifier(context -> context.useModifier(this::applyToRotation));
        ControlifyEvents.LOOK_INPUT_MODIFIER.register(event -> {
            if (ClientEvents.isFallFlying()) {
                event.lookInput().zero();
            }
        });
    }

    public void onControllersDiscovered(ControlifyApi controlifyApi) {
    }
}

