/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.rollable.flight;

import com.iafenvoy.rollable.event.Event;
import com.iafenvoy.rollable.flight.RollContext;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public final class RollProcessGroup {
    public static final Event<Supplier<RollProcessGroup>> SHOULD_ROLL = new Event<Supplier>(listeners -> () -> listeners.stream().map(Supplier::get).filter(RollProcessGroup::enabled).findFirst().orElse(null));
    private static final Map<class_2960, RollProcessGroup> BY_ID = new HashMap<class_2960, RollProcessGroup>();
    private final class_2960 id;
    private final Event<BooleanSupplier> enabled = new Event<BooleanSupplier>(listeners -> () -> {
        for (BooleanSupplier listener : listeners) {
            if (!listener.getAsBoolean()) continue;
            return true;
        }
        return false;
    });
    private final Event<Consumer<RollContext>> beforeModifier = new Event<Consumer>(listeners -> context -> listeners.forEach(x -> x.accept(context)));
    private final Event<Consumer<RollContext>> afterModifier = new Event<Consumer>(listeners -> context -> listeners.forEach(x -> x.accept(context)));

    private RollProcessGroup(class_2960 id) {
        this.id = id;
        SHOULD_ROLL.register(() -> this);
    }

    public static RollProcessGroup get(class_2960 id) {
        return BY_ID.computeIfAbsent(id, RollProcessGroup::new);
    }

    public class_2960 getId() {
        return this.id;
    }

    public void registerEnablePredicate(BooleanSupplier predicate) {
        this.enabled.register(predicate);
    }

    public void registerBeforeModifier(Consumer<RollContext> modifier) {
        this.beforeModifier.register(modifier);
    }

    public void registerAfterModifier(Consumer<RollContext> modifier) {
        this.afterModifier.register(modifier);
    }

    public boolean enabled() {
        return this.enabled.invoker().getAsBoolean();
    }

    public void processBeforeModifier(RollContext context) {
        this.beforeModifier.invoker().accept(context);
    }

    public void processAfterModifier(RollContext context) {
        this.afterModifier.invoker().accept(context);
    }
}

