/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.rollable.flight.modifier;

import com.iafenvoy.rollable.RollableKeybindings;
import com.iafenvoy.rollable.config.RollableClientConfig;
import com.iafenvoy.rollable.expression.Expression;
import com.iafenvoy.rollable.expression.ExpressionParser;
import com.iafenvoy.rollable.flight.RollContext;
import com.iafenvoy.rollable.flight.RotateState;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3540;
import net.minecraft.class_746;

public class RotationModifiers {
    public static final double ROLL_REORIENT_CUTOFF = Math.sqrt(3.3333333333333335);

    public static RotateState configureRotation(RotateState state, RollContext context) {
        double pitch = state.pitch();
        double yaw = state.yaw();
        double roll = state.roll();
        if (!((Boolean)RollableClientConfig.INSTANCE.generals.switchRollAndYaw.getValue()).booleanValue()) {
            double temp = yaw;
            yaw = roll;
            roll = temp;
        }
        if (((Boolean)RollableClientConfig.INSTANCE.generals.invertPitch.getValue()).booleanValue()) {
            pitch *= -1.0;
        }
        return new RotateState(pitch, yaw, roll);
    }

    public static RollContext.ConfiguresRotation buttonControls(double power) {
        return (state, context) -> {
            double delta = power * context.getRenderDelta();
            double pitch = 0.0;
            double yaw = 0.0;
            double roll = 0.0;
            if (RollableKeybindings.isPitchUpPressed()) {
                pitch -= delta;
            }
            if (RollableKeybindings.isPitchDownPressed()) {
                pitch += delta;
            }
            if (RollableKeybindings.isYawLeftPressed()) {
                yaw -= delta;
            }
            if (RollableKeybindings.isYawRightPressed()) {
                yaw += delta;
            }
            if (RollableKeybindings.isRollLeftPressed()) {
                roll -= delta;
            }
            if (RollableKeybindings.isRollRightPressed()) {
                roll += delta;
            }
            return state.add(pitch, yaw, roll);
        };
    }

    public static RollContext.ConfiguresRotation smoothing(class_3540 pitchSmoother, class_3540 yawSmoother, class_3540 rollSmoother, RotateState smoothness) {
        return (state, context) -> new RotateState(smoothness.pitch() == 0.0 ? state.pitch() : pitchSmoother.method_15429(state.pitch(), 1.0 / smoothness.pitch() * context.getRenderDelta()), smoothness.yaw() == 0.0 ? state.yaw() : yawSmoother.method_15429(state.yaw(), 1.0 / smoothness.yaw() * context.getRenderDelta()), smoothness.roll() == 0.0 ? state.roll() : rollSmoother.method_15429(state.roll(), 1.0 / smoothness.roll() * context.getRenderDelta()));
    }

    public static RotateState banking(RotateState state, RollContext context) {
        double delta = context.getRenderDelta();
        RotateState currentRotation = context.getCurrentRotation();
        double currentRoll = Math.toRadians(currentRotation.roll());
        Expression xExpression = ((ExpressionParser)RollableClientConfig.INSTANCE.advanced.bankingXFormula.getValue()).getCompiledOrDefaulting(0.0);
        Expression yExpression = ((ExpressionParser)RollableClientConfig.INSTANCE.advanced.bankingYFormula.getValue()).getCompiledOrDefaulting(0.0);
        Map<String, Double> vars = RotationModifiers.getVars(context);
        vars.put("banking_strength", (Double)RollableClientConfig.INSTANCE.banking.strength.getValue());
        double dX = xExpression.eval(vars);
        double dY = yExpression.eval(vars);
        if (Double.isNaN(dX)) {
            dX = 0.0;
        }
        if (Double.isNaN(dY)) {
            dY = 0.0;
        }
        return state.addAbsolute(dX * delta, dY * delta, currentRoll);
    }

    public static RotateState reorient(RotateState state, RollContext context) {
        double delta = context.getRenderDelta();
        double currentRoll = Math.toRadians(context.getCurrentRotation().roll());
        double strength = 10.0 * (Double)RollableClientConfig.INSTANCE.banking.rightingStrength.getValue();
        double cutoff = ROLL_REORIENT_CUTOFF;
        double rollDelta = 0.0;
        if (-cutoff < currentRoll && currentRoll < cutoff) {
            rollDelta = -Math.pow(currentRoll, 3.0) / 3.0 + currentRoll;
        }
        return state.add(0.0, 0.0, -rollDelta * strength * delta);
    }

    public static RotateState applyControlSurfaceEfficacy(RotateState state, RollContext context) {
        Expression elevatorExpression = ((ExpressionParser)RollableClientConfig.INSTANCE.advanced.elevatorEfficacyFormula.getValue()).getCompiledOrDefaulting(1.0);
        Expression aileronExpression = ((ExpressionParser)RollableClientConfig.INSTANCE.advanced.aileronEfficacyFormula.getValue()).getCompiledOrDefaulting(1.0);
        Expression rudderExpression = ((ExpressionParser)RollableClientConfig.INSTANCE.advanced.rudderEfficacyFormula.getValue()).getCompiledOrDefaulting(1.0);
        Map<String, Double> vars = RotationModifiers.getVars(context);
        return state.multiply(elevatorExpression.eval(vars), rudderExpression.eval(vars), aileronExpression.eval(vars));
    }

    private static Map<String, Double> getVars(RollContext context) {
        final class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        final RotateState currentRotation = context.getCurrentRotation();
        final class_243 rotationVector = player.method_5720();
        return new HashMap<String, Double>(){
            {
                this.put("pitch", currentRotation.pitch());
                this.put("yaw", currentRotation.yaw());
                this.put("roll", currentRotation.roll());
                this.put("velocity_length", player.method_18798().method_1033());
                this.put("velocity_x", player.method_18798().method_10216());
                this.put("velocity_y", player.method_18798().method_10214());
                this.put("velocity_z", player.method_18798().method_10215());
                this.put("look_x", rotationVector.method_10216());
                this.put("look_y", rotationVector.method_10214());
                this.put("look_z", rotationVector.method_10215());
            }
        };
    }
}

