/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.rollable.mixin;

import com.iafenvoy.rollable.api.RollableEntity;
import com.iafenvoy.rollable.flight.RollContext;
import com.iafenvoy.rollable.flight.RollProcessGroup;
import com.iafenvoy.rollable.flight.RotateState;
import com.mojang.authlib.GameProfile;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_746.class})
public abstract class ClientPlayerEntityMixin
extends class_1657
implements RollableEntity {
    @Shadow
    public float field_3932;
    @Shadow
    public float field_3931;
    @Unique
    @Nullable
    protected RollProcessGroup rollable$processGroup;
    @Unique
    protected float rollable$prevRoll;
    @Unique
    protected float rollable$roll;

    public ClientPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tickTail(CallbackInfo ci) {
        this.rollable$processGroup = RollProcessGroup.SHOULD_ROLL.invoker().get();
        this.rollable$prevRoll = this.rollable$getRoll();
        if (!this.rollable$isRolling()) {
            this.rollable$setRoll(0.0f);
        }
    }

    @Override
    public boolean rollable$isRolling() {
        return this.rollable$processGroup != null;
    }

    @Override
    public float rollable$getRoll() {
        return this.rollable$roll;
    }

    @Override
    public float rollable$getRoll(float tickDelta) {
        if (tickDelta == 1.0f) {
            return this.rollable$getRoll();
        }
        return class_3532.method_16439((float)tickDelta, (float)this.rollable$prevRoll, (float)this.rollable$getRoll());
    }

    @Override
    public void rollable$setRoll(float roll) {
        if (!Float.isFinite(roll)) {
            class_156.method_33559((String)("Invalid entity rotation: " + roll + ", discarding."));
            return;
        }
        float lastRoll = this.rollable$getRoll();
        this.rollable$roll = roll;
        if (roll < -90.0f && lastRoll > 90.0f) {
            this.rollable$prevRoll -= 360.0f;
        } else if (roll > 90.0f && lastRoll < -90.0f) {
            this.rollable$prevRoll += 360.0f;
        }
    }

    @Override
    @Nullable
    public RollProcessGroup rollable$getCurrentProcessGroup() {
        return this.rollable$processGroup;
    }

    @Override
    public void rollable$changeLook(double pitch, double yaw, double roll, RotateState state, double mouseDelta) {
        RotateState rotDelta = new RotateState(pitch, yaw, roll);
        float currentRoll = this.rollable$getRoll();
        double pitch1 = this.method_36455();
        double yaw1 = this.method_36454();
        RotateState currentRotation = new RotateState(pitch1, yaw1, currentRoll);
        RollContext context = new RollContext(currentRotation, rotDelta, mouseDelta);
        if (this.rollable$processGroup != null) {
            this.rollable$processGroup.processBeforeModifier(context);
        }
        context.useModifier((rotation, ctx) -> rotation.multiply(state));
        if (this.rollable$processGroup != null) {
            this.rollable$processGroup.processAfterModifier(context);
        }
        rotDelta = context.getRotationDelta();
        this.rollable$changeLook((float)rotDelta.pitch(), (float)rotDelta.yaw(), (float)rotDelta.roll());
    }

    @Override
    public void rollable$changeLook(float pitch, float yaw, float roll) {
        float currentPitch = this.method_36455();
        float currentYaw = this.method_36454();
        float currentRoll = this.rollable$getRoll();
        Vector3d facing = new Vector3d((Vector3fc)this.method_5663().method_46409());
        Vector3d left = new Vector3d(1.0, 0.0, 0.0);
        left.rotateZ(-Math.toRadians(currentRoll));
        left.rotateX(-Math.toRadians(currentPitch));
        left.rotateY(-Math.toRadians(currentYaw + 180.0f));
        facing.rotateAxis(-0.15 * Math.toRadians(pitch), left.x, left.y, left.z);
        Vector3d up = facing.cross((Vector3dc)left, new Vector3d());
        facing.rotateAxis(0.15 * Math.toRadians(yaw), up.x, up.y, up.z);
        left.rotateAxis(0.15 * Math.toRadians(yaw), up.x, up.y, up.z);
        left.rotateAxis(0.15 * Math.toRadians(roll), facing.x, facing.y, facing.z);
        double newPitch = Math.toDegrees(-Math.asin(facing.y));
        double newYaw = Math.toDegrees(-Math.atan2(facing.x, facing.z));
        Vector3d normalLeft = new Vector3d(1.0, 0.0, 0.0).rotateY(Math.toRadians(-newYaw - 180.0));
        double newRoll = Math.toDegrees(-Math.atan2(left.cross((Vector3dc)normalLeft, new Vector3d()).dot((Vector3dc)facing), left.dot((Vector3dc)normalLeft)));
        double deltaY = newPitch - (double)currentPitch;
        double deltaX = newYaw - (double)currentYaw;
        double deltaRoll = newRoll - (double)currentRoll;
        this.method_5872(deltaX / 0.15, deltaY / 0.15);
        this.rollable$roll += (float)deltaRoll;
        this.rollable$prevRoll += (float)deltaRoll;
        if (this.method_36454() < -90.0f && this.field_3932 > 90.0f) {
            this.field_3932 -= 360.0f;
            this.field_3931 -= 360.0f;
        } else if (this.method_36454() > 90.0f && this.field_3932 < -90.0f) {
            this.field_3932 += 360.0f;
            this.field_3931 += 360.0f;
        }
    }
}

