/*
 * Decompiled with CFR 0.152.
 */
package com.technoguyfication.admingpt;

import com.technoguyfication.admingpt.bukkit.Metrics;
import com.technoguyfication.admingpt.charts.SimplePie;
import com.technoguyfication.admingpt.charts.SingleLineChart;
import com.technoguyfication.admingpt.openai.completion.chat.ChatCompletionRequest;
import com.technoguyfication.admingpt.openai.completion.chat.ChatCompletionResult;
import com.technoguyfication.admingpt.openai.completion.chat.ChatMessage;
import com.technoguyfication.admingpt.openai.completion.chat.ChatMessageRole;
import com.technoguyfication.admingpt.openai.service.OpenAiService;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventException;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AdminGPT
extends JavaPlugin
implements Listener {
    Pattern responsePattern = Pattern.compile("<([ctp])>\\/?(.*)<\\/[ctp]>");
    OpenAiService service;
    LinkedList<ChatMessage> messageHistory = new LinkedList();
    String systemPrompt;
    String languageModel;
    int historyLength;
    long timeoutSeconds;
    Double temperature;
    List<String> commandBlacklist;
    int totalMessages = 0;
    int totalCommands = 0;
    int totalResponses = 0;

    @Override
    public void onEnable() {
        int pluginId = 18196;
        Metrics metrics = new Metrics(this, pluginId);
        FileConfiguration config = this.getConfig();
        InputStream langStream = this.getResource("lang.yml");
        YamlConfiguration langConfig = new YamlConfiguration();
        try {
            langConfig.load(new InputStreamReader(langStream));
            this.systemPrompt = langConfig.getString("openai-system-prompt");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to load lang.yml file.");
            e.printStackTrace();
            this.setEnabled(false);
            return;
        }
        String apiKey = config.getString("openai-api-key");
        if (apiKey == null || apiKey.isBlank() || apiKey.equals("your-api-key-here")) {
            this.getLogger().severe("No OpenAI API key found in config.yml. Please add one and restart the server.");
            this.saveDefaultConfig();
            this.setEnabled(false);
            return;
        }
        this.languageModel = config.getString("openai-language-model");
        this.temperature = config.getDouble("openai-model-temperature");
        this.timeoutSeconds = config.getLong("openai-timeout-secs");
        this.historyLength = config.getInt("history-length");
        this.commandBlacklist = config.getStringList("command-blacklist");
        metrics.addCustomChart(new SimplePie("language-model", () -> this.languageModel));
        metrics.addCustomChart(new SingleLineChart("messages-sent", () -> {
            int total = this.totalMessages;
            this.totalMessages = 0;
            return total;
        }));
        metrics.addCustomChart(new SingleLineChart("commands-run", () -> {
            int total = this.totalCommands;
            this.totalCommands = 0;
            return total;
        }));
        metrics.addCustomChart(new SingleLineChart("responses-received", () -> {
            int total = this.totalResponses;
            this.totalResponses = 0;
            return total;
        }));
        this.service = new OpenAiService(apiKey, Duration.ofSeconds(this.timeoutSeconds));
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getLogger().info("Command blacklist: " + String.join((CharSequence)", ", this.commandBlacklist));
    }

    @Override
    public void onDisable() {
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) throws EventException {
        ++this.totalMessages;
        this.addChatMessage(new ChatMessage(ChatMessageRole.USER.value(), String.format("%s: %s", event.getPlayer().getName(), event.getMessage())));
        String templatedSystemPrompt = this.systemPrompt.replace("{plugins}", String.join((CharSequence)", ", (CharSequence[])Stream.of(Bukkit.getPluginManager().getPlugins()).map(p -> p.getName()).toArray(String[]::new))).replace("{players}", String.join((CharSequence)", ", (CharSequence[])Bukkit.getOnlinePlayers().stream().map(p -> p.getName()).toArray(String[]::new))).replace("{version}", Bukkit.getVersion());
        LinkedList<ChatMessage> messages = new LinkedList<ChatMessage>();
        messages.add(new ChatMessage(ChatMessageRole.SYSTEM.value(), templatedSystemPrompt));
        messages.addAll(this.messageHistory);
        ChatCompletionRequest request = ChatCompletionRequest.builder().model(this.languageModel).messages(messages).user(event.getPlayer().getUniqueId().toString()).temperature(this.temperature).build();
        this.getLogger().fine("Sending chat completion request to OpenAI...");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            ChatCompletionResult result = this.service.createChatCompletion(request);
            ChatMessage responseMessage = result.getChoices().get(0).getMessage();
            this.getLogger().fine("Received chat completion result from OpenAI.");
            LinkedList<String> commands = new LinkedList<String>();
            LinkedList<String> responses = new LinkedList<String>();
            block10: for (String line : responseMessage.getContent().split("\\r?\\n")) {
                Matcher matcher = this.responsePattern.matcher(line);
                if (!matcher.find()) continue;
                switch (matcher.group(1)) {
                    case "c": {
                        String command = matcher.group(2);
                        this.getLogger().info(String.format("Command: %s", command));
                        commands.add(command);
                        continue block10;
                    }
                    case "t": {
                        String thought = matcher.group(2);
                        this.getLogger().info(String.format("Thought: %s", thought));
                        continue block10;
                    }
                    case "p": {
                        String response = matcher.group(2);
                        this.getLogger().info(String.format("Response: %s", response));
                        responses.add(response);
                        continue block10;
                    }
                    default: {
                        this.getLogger().warning(String.format("Invalid response pattern: %s", line));
                    }
                }
            }
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                this.totalCommands += commands.size();
                this.totalResponses += responses.size();
                this.addChatMessage(responseMessage);
                for (String command : commands) {
                    String rootCommand = command.split(" ")[0];
                    if (this.commandBlacklist.contains(rootCommand.toLowerCase())) {
                        this.getLogger().warning(String.format("Command %s is blacklisted.", command));
                        continue;
                    }
                    Bukkit.dispatchCommand(Bukkit.getConsoleSender(), command);
                }
                for (String response : responses) {
                    Bukkit.broadcastMessage(ChatColor.AQUA + String.format("<AdminGPT> %s", response));
                }
            });
        });
    }

    private void addChatMessage(ChatMessage message) {
        if (this.messageHistory.size() >= this.historyLength) {
            this.messageHistory.removeFirst();
        }
        this.messageHistory.add(message);
    }
}

