/*
 * Decompiled with CFR 0.152.
 */
package com.technoguyfication.admingpt.openai;

import com.technoguyfication.admingpt.openai.DeleteResult;
import com.technoguyfication.admingpt.openai.OpenAiResponse;
import com.technoguyfication.admingpt.openai.completion.CompletionRequest;
import com.technoguyfication.admingpt.openai.completion.CompletionResult;
import com.technoguyfication.admingpt.openai.completion.chat.ChatCompletionRequest;
import com.technoguyfication.admingpt.openai.completion.chat.ChatCompletionResult;
import com.technoguyfication.admingpt.openai.edit.EditRequest;
import com.technoguyfication.admingpt.openai.edit.EditResult;
import com.technoguyfication.admingpt.openai.embedding.EmbeddingRequest;
import com.technoguyfication.admingpt.openai.embedding.EmbeddingResult;
import com.technoguyfication.admingpt.openai.engine.Engine;
import com.technoguyfication.admingpt.openai.file.File;
import com.technoguyfication.admingpt.openai.finetune.FineTuneEvent;
import com.technoguyfication.admingpt.openai.finetune.FineTuneRequest;
import com.technoguyfication.admingpt.openai.finetune.FineTuneResult;
import com.technoguyfication.admingpt.openai.image.CreateImageRequest;
import com.technoguyfication.admingpt.openai.image.ImageResult;
import com.technoguyfication.admingpt.openai.model.Model;
import com.technoguyfication.admingpt.openai.moderation.ModerationRequest;
import com.technoguyfication.admingpt.openai.moderation.ModerationResult;
import io.reactivex.Single;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Streaming;

public interface OpenAiApi {
    @GET(value="v1/models")
    public Single<OpenAiResponse<Model>> listModels();

    @GET(value="/v1/models/{model_id}")
    public Single<Model> getModel(@Path(value="model_id") String var1);

    @POST(value="/v1/completions")
    public Single<CompletionResult> createCompletion(@Body CompletionRequest var1);

    @Streaming
    @POST(value="/v1/completions")
    public Call<ResponseBody> createCompletionStream(@Body CompletionRequest var1);

    @POST(value="/v1/chat/completions")
    public Single<ChatCompletionResult> createChatCompletion(@Body ChatCompletionRequest var1);

    @Streaming
    @POST(value="/v1/chat/completions")
    public Call<ResponseBody> createChatCompletionStream(@Body ChatCompletionRequest var1);

    @Deprecated
    @POST(value="/v1/engines/{engine_id}/completions")
    public Single<CompletionResult> createCompletion(@Path(value="engine_id") String var1, @Body CompletionRequest var2);

    @POST(value="/v1/edits")
    public Single<EditResult> createEdit(@Body EditRequest var1);

    @Deprecated
    @POST(value="/v1/engines/{engine_id}/edits")
    public Single<EditResult> createEdit(@Path(value="engine_id") String var1, @Body EditRequest var2);

    @POST(value="/v1/embeddings")
    public Single<EmbeddingResult> createEmbeddings(@Body EmbeddingRequest var1);

    @Deprecated
    @POST(value="/v1/engines/{engine_id}/embeddings")
    public Single<EmbeddingResult> createEmbeddings(@Path(value="engine_id") String var1, @Body EmbeddingRequest var2);

    @GET(value="/v1/files")
    public Single<OpenAiResponse<File>> listFiles();

    @Multipart
    @POST(value="/v1/files")
    public Single<File> uploadFile(@Part(value="purpose") RequestBody var1, @Part MultipartBody.Part var2);

    @DELETE(value="/v1/files/{file_id}")
    public Single<DeleteResult> deleteFile(@Path(value="file_id") String var1);

    @GET(value="/v1/files/{file_id}")
    public Single<File> retrieveFile(@Path(value="file_id") String var1);

    @POST(value="/v1/fine-tunes")
    public Single<FineTuneResult> createFineTune(@Body FineTuneRequest var1);

    @POST(value="/v1/completions")
    public Single<CompletionResult> createFineTuneCompletion(@Body CompletionRequest var1);

    @GET(value="/v1/fine-tunes")
    public Single<OpenAiResponse<FineTuneResult>> listFineTunes();

    @GET(value="/v1/fine-tunes/{fine_tune_id}")
    public Single<FineTuneResult> retrieveFineTune(@Path(value="fine_tune_id") String var1);

    @POST(value="/v1/fine-tunes/{fine_tune_id}/cancel")
    public Single<FineTuneResult> cancelFineTune(@Path(value="fine_tune_id") String var1);

    @GET(value="/v1/fine-tunes/{fine_tune_id}/events")
    public Single<OpenAiResponse<FineTuneEvent>> listFineTuneEvents(@Path(value="fine_tune_id") String var1);

    @DELETE(value="/v1/models/{fine_tune_id}")
    public Single<DeleteResult> deleteFineTune(@Path(value="fine_tune_id") String var1);

    @POST(value="/v1/images/generations")
    public Single<ImageResult> createImage(@Body CreateImageRequest var1);

    @POST(value="/v1/images/edits")
    public Single<ImageResult> createImageEdit(@Body RequestBody var1);

    @POST(value="/v1/images/variations")
    public Single<ImageResult> createImageVariation(@Body RequestBody var1);

    @POST(value="/v1/moderations")
    public Single<ModerationResult> createModeration(@Body ModerationRequest var1);

    @Deprecated
    @GET(value="v1/engines")
    public Single<OpenAiResponse<Engine>> getEngines();

    @Deprecated
    @GET(value="/v1/engines/{engine_id}")
    public Single<Engine> getEngine(@Path(value="engine_id") String var1);
}

