/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.observers;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.plugins.RxJavaPlugins;

public abstract class BasicFuseableObserver<T, R>
implements Observer<T>,
QueueDisposable<R> {
    protected final Observer<? super R> actual;
    protected Disposable s;
    protected QueueDisposable<T> qs;
    protected boolean done;
    protected int sourceMode;

    public BasicFuseableObserver(Observer<? super R> actual) {
        this.actual = actual;
    }

    @Override
    public final void onSubscribe(Disposable s2) {
        if (DisposableHelper.validate(this.s, s2)) {
            this.s = s2;
            if (s2 instanceof QueueDisposable) {
                this.qs = (QueueDisposable)s2;
            }
            if (this.beforeDownstream()) {
                this.actual.onSubscribe(this);
                this.afterDownstream();
            }
        }
    }

    protected boolean beforeDownstream() {
        return true;
    }

    protected void afterDownstream() {
    }

    @Override
    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.done = true;
        this.actual.onError(t);
    }

    protected final void fail(Throwable t) {
        Exceptions.throwIfFatal(t);
        this.s.dispose();
        this.onError(t);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }

    protected final int transitiveBoundaryFusion(int mode) {
        QueueDisposable<T> qs = this.qs;
        if (qs != null && (mode & 4) == 0) {
            int m3 = qs.requestFusion(mode);
            if (m3 != 0) {
                this.sourceMode = m3;
            }
            return m3;
        }
        return 0;
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public boolean isEmpty() {
        return this.qs.isEmpty();
    }

    @Override
    public void clear() {
        this.qs.clear();
    }

    @Override
    public final boolean offer(R e) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Override
    public final boolean offer(R v1, R v2) {
        throw new UnsupportedOperationException("Should not be called!");
    }
}

