/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.SequentialDisposable;

public final class CompletableResumeNext
extends Completable {
    final CompletableSource source;
    final Function<? super Throwable, ? extends CompletableSource> errorMapper;

    public CompletableResumeNext(CompletableSource source, Function<? super Throwable, ? extends CompletableSource> errorMapper) {
        this.source = source;
        this.errorMapper = errorMapper;
    }

    @Override
    protected void subscribeActual(final CompletableObserver s2) {
        final SequentialDisposable sd = new SequentialDisposable();
        s2.onSubscribe(sd);
        this.source.subscribe(new CompletableObserver(){

            @Override
            public void onComplete() {
                s2.onComplete();
            }

            @Override
            public void onError(Throwable e) {
                CompletableSource c;
                try {
                    c = CompletableResumeNext.this.errorMapper.apply(e);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    s2.onError(new CompositeException(ex, e));
                    return;
                }
                if (c == null) {
                    NullPointerException npe = new NullPointerException("The CompletableConsumable returned is null");
                    npe.initCause(e);
                    s2.onError(npe);
                    return;
                }
                c.subscribe(new CompletableObserver(){

                    @Override
                    public void onComplete() {
                        s2.onComplete();
                    }

                    @Override
                    public void onError(Throwable e) {
                        s2.onError(e);
                    }

                    @Override
                    public void onSubscribe(Disposable d) {
                        sd.update(d);
                    }
                });
            }

            @Override
            public void onSubscribe(Disposable d) {
                sd.update(d);
            }
        });
    }
}

