/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BooleanSupplier;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableBuffer<T, C extends Collection<? super T>>
extends AbstractFlowableWithUpstream<T, C> {
    final int size;
    final int skip;
    final Callable<C> bufferSupplier;

    public FlowableBuffer(Publisher<T> source, int size, int skip, Callable<C> bufferSupplier) {
        super(source);
        this.size = size;
        this.skip = skip;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    public void subscribeActual(Subscriber<? super C> s2) {
        if (this.size == this.skip) {
            this.source.subscribe(new PublisherBufferExactSubscriber(s2, this.size, this.bufferSupplier));
        } else if (this.skip > this.size) {
            this.source.subscribe(new PublisherBufferSkipSubscriber(s2, this.size, this.skip, this.bufferSupplier));
        } else {
            this.source.subscribe(new PublisherBufferOverlappingSubscriber(s2, this.size, this.skip, this.bufferSupplier));
        }
    }

    static final class PublisherBufferOverlappingSubscriber<T, C extends Collection<? super T>>
    extends AtomicLong
    implements Subscriber<T>,
    Subscription,
    BooleanSupplier {
        private static final long serialVersionUID = -7370244972039324525L;
        final Subscriber<? super C> actual;
        final Callable<C> bufferSupplier;
        final int size;
        final int skip;
        final ArrayDeque<C> buffers;
        final AtomicBoolean once;
        Subscription s;
        boolean done;
        int index;
        volatile boolean cancelled;
        long produced;

        PublisherBufferOverlappingSubscriber(Subscriber<? super C> actual, int size, int skip, Callable<C> bufferSupplier) {
            this.actual = actual;
            this.size = size;
            this.skip = skip;
            this.bufferSupplier = bufferSupplier;
            this.once = new AtomicBoolean();
            this.buffers = new ArrayDeque();
        }

        @Override
        public boolean getAsBoolean() {
            return this.cancelled;
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                if (QueueDrainHelper.postCompleteRequest(n, this.actual, this.buffers, this, this)) {
                    return;
                }
                if (!this.once.get() && this.once.compareAndSet(false, true)) {
                    long u = BackpressureHelper.multiplyCap(this.skip, n - 1L);
                    long r = BackpressureHelper.addCap(this.size, u);
                    this.s.request(r);
                } else {
                    long r = BackpressureHelper.multiplyCap(this.skip, n);
                    this.s.request(r);
                }
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.s, s2)) {
                this.s = s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            Collection b;
            if (this.done) {
                return;
            }
            ArrayDeque<C> bs = this.buffers;
            int i = this.index;
            if (i++ == 0) {
                try {
                    b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null buffer");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.cancel();
                    this.onError(e);
                    return;
                }
                bs.offer(b);
            }
            if ((b = (Collection)bs.peek()) != null && b.size() + 1 == this.size) {
                bs.poll();
                b.add(t);
                ++this.produced;
                this.actual.onNext(b);
            }
            for (Collection b0 : bs) {
                b0.add(t);
            }
            if (i == this.skip) {
                i = 0;
            }
            this.index = i;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.buffers.clear();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            long p = this.produced;
            if (p != 0L) {
                BackpressureHelper.produced(this, p);
            }
            QueueDrainHelper.postComplete(this.actual, this.buffers, this, this);
        }
    }

    static final class PublisherBufferSkipSubscriber<T, C extends Collection<? super T>>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -5616169793639412593L;
        final Subscriber<? super C> actual;
        final Callable<C> bufferSupplier;
        final int size;
        final int skip;
        C buffer;
        Subscription s;
        boolean done;
        int index;

        PublisherBufferSkipSubscriber(Subscriber<? super C> actual, int size, int skip, Callable<C> bufferSupplier) {
            this.actual = actual;
            this.size = size;
            this.skip = skip;
            this.bufferSupplier = bufferSupplier;
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                if (this.get() == 0 && this.compareAndSet(0, 1)) {
                    long u = BackpressureHelper.multiplyCap(n, this.size);
                    long v = BackpressureHelper.multiplyCap(this.skip - this.size, n - 1L);
                    this.s.request(BackpressureHelper.addCap(u, v));
                } else {
                    this.s.request(BackpressureHelper.multiplyCap(this.skip, n));
                }
            }
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.s, s2)) {
                this.s = s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            Object b = this.buffer;
            int i = this.index;
            if (i++ == 0) {
                try {
                    b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null buffer");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.cancel();
                    this.onError(e);
                    return;
                }
                this.buffer = b;
            }
            if (b != null) {
                b.add(t);
                if (b.size() == this.size) {
                    this.buffer = null;
                    this.actual.onNext(b);
                }
            }
            if (i == this.skip) {
                i = 0;
            }
            this.index = i;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.buffer = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            C b = this.buffer;
            this.buffer = null;
            if (b != null) {
                this.actual.onNext(b);
            }
            this.actual.onComplete();
        }
    }

    static final class PublisherBufferExactSubscriber<T, C extends Collection<? super T>>
    implements Subscriber<T>,
    Subscription {
        final Subscriber<? super C> actual;
        final Callable<C> bufferSupplier;
        final int size;
        C buffer;
        Subscription s;
        boolean done;
        int index;

        PublisherBufferExactSubscriber(Subscriber<? super C> actual, int size, Callable<C> bufferSupplier) {
            this.actual = actual;
            this.size = size;
            this.bufferSupplier = bufferSupplier;
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                this.s.request(BackpressureHelper.multiplyCap(n, this.size));
            }
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.s, s2)) {
                this.s = s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            Object b = this.buffer;
            if (b == null) {
                try {
                    b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null buffer");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.cancel();
                    this.onError(e);
                    return;
                }
                this.buffer = b;
            }
            b.add(t);
            int i = this.index + 1;
            if (i == this.size) {
                this.index = 0;
                this.buffer = null;
                this.actual.onNext(b);
            } else {
                this.index = i;
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            C b = this.buffer;
            if (b != null && !b.isEmpty()) {
                this.actual.onNext(b);
            }
            this.actual.onComplete();
        }
    }
}

