/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.internal.subscribers.BasicFuseableSubscriber;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class FlowableDoOnEach<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Consumer<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Action onAfterTerminate;

    public FlowableDoOnEach(Publisher<T> source, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
        super(source);
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onAfterTerminate = onAfterTerminate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        if (s2 instanceof ConditionalSubscriber) {
            this.source.subscribe(new DoOnEachConditionalSubscriber<T>((ConditionalSubscriber)s2, this.onNext, this.onError, this.onComplete, this.onAfterTerminate));
        } else {
            this.source.subscribe(new DoOnEachSubscriber<T>(s2, this.onNext, this.onError, this.onComplete, this.onAfterTerminate));
        }
    }

    static final class DoOnEachConditionalSubscriber<T>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final Consumer<? super T> onNext;
        final Consumer<? super Throwable> onError;
        final Action onComplete;
        final Action onAfterTerminate;

        DoOnEachConditionalSubscriber(ConditionalSubscriber<? super T> actual, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
            super(actual);
            this.onNext = onNext;
            this.onError = onError;
            this.onComplete = onComplete;
            this.onAfterTerminate = onAfterTerminate;
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(null);
                return;
            }
            try {
                this.onNext.accept(t);
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.actual.onNext(t);
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                return false;
            }
            try {
                this.onNext.accept(t);
            }
            catch (Throwable e) {
                this.fail(e);
                return false;
            }
            return this.actual.tryOnNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            boolean relay = true;
            try {
                this.onError.accept(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(new CompositeException(t, e));
                relay = false;
            }
            if (relay) {
                this.actual.onError(t);
            }
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            try {
                this.onComplete.run();
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.done = true;
            this.actual.onComplete();
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T poll() throws Exception {
            Object v = this.qs.poll();
            if (v != null) {
                try {
                    this.onNext.accept(v);
                }
                finally {
                    this.onAfterTerminate.run();
                }
            } else if (this.sourceMode == 1) {
                this.onComplete.run();
                this.onAfterTerminate.run();
            }
            return v;
        }
    }

    static final class DoOnEachSubscriber<T>
    extends BasicFuseableSubscriber<T, T> {
        final Consumer<? super T> onNext;
        final Consumer<? super Throwable> onError;
        final Action onComplete;
        final Action onAfterTerminate;

        DoOnEachSubscriber(Subscriber<? super T> actual, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
            super(actual);
            this.onNext = onNext;
            this.onError = onError;
            this.onComplete = onComplete;
            this.onAfterTerminate = onAfterTerminate;
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(null);
                return;
            }
            try {
                this.onNext.accept(t);
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            boolean relay = true;
            try {
                this.onError.accept(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(new CompositeException(t, e));
                relay = false;
            }
            if (relay) {
                this.actual.onError(t);
            }
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            try {
                this.onComplete.run();
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.done = true;
            this.actual.onComplete();
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T poll() throws Exception {
            Object v = this.qs.poll();
            if (v != null) {
                try {
                    this.onNext.accept(v);
                }
                finally {
                    this.onAfterTerminate.run();
                }
            } else if (this.sourceMode == 1) {
                this.onComplete.run();
                this.onAfterTerminate.run();
            }
            return v;
        }
    }
}

