/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRepeat<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long count;

    public FlowableRepeat(Publisher<T> source, long count) {
        super(source);
        this.count = count;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        SubscriptionArbiter sa = new SubscriptionArbiter();
        s2.onSubscribe(sa);
        RepeatSubscriber<T> rs = new RepeatSubscriber<T>(s2, this.count != Long.MAX_VALUE ? this.count - 1L : Long.MAX_VALUE, sa, this.source);
        rs.subscribeNext();
    }

    static final class RepeatSubscriber<T>
    extends AtomicInteger
    implements Subscriber<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Subscriber<? super T> actual;
        final SubscriptionArbiter sa;
        final Publisher<? extends T> source;
        long remaining;

        RepeatSubscriber(Subscriber<? super T> actual, long count, SubscriptionArbiter sa, Publisher<? extends T> source) {
            this.actual = actual;
            this.sa = sa;
            this.source = source;
            this.remaining = count;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            this.sa.setSubscription(s2);
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
            this.sa.produced(1L);
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            long r = this.remaining;
            if (r != Long.MAX_VALUE) {
                this.remaining = r - 1L;
            }
            if (r != 0L) {
                this.subscribeNext();
            } else {
                this.actual.onComplete();
            }
        }

        void subscribeNext() {
            block2: {
                if (this.getAndIncrement() != 0) break block2;
                int missed = 1;
                do {
                    if (this.sa.isCancelled()) {
                        return;
                    }
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

