/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Scheduler;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSubscribeOn<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Scheduler scheduler;
    final boolean nonScheduledRequests;

    public FlowableSubscribeOn(Publisher<T> source, Scheduler scheduler, boolean nonScheduledRequests) {
        super(source);
        this.scheduler = scheduler;
        this.nonScheduledRequests = nonScheduledRequests;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        Scheduler.Worker w = this.scheduler.createWorker();
        SubscribeOnSubscriber<? super T> sos = new SubscribeOnSubscriber<T>(s2, w, this.source, this.nonScheduledRequests);
        s2.onSubscribe(sos);
        w.schedule(sos);
    }

    static final class SubscribeOnSubscriber<T>
    extends AtomicReference<Thread>
    implements Subscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 8094547886072529208L;
        final Subscriber<? super T> actual;
        final Scheduler.Worker worker;
        final AtomicReference<Subscription> s;
        final AtomicLong requested;
        final boolean nonScheduledRequests;
        Publisher<T> source;

        SubscribeOnSubscriber(Subscriber<? super T> actual, Scheduler.Worker worker, Publisher<T> source, boolean nonScheduledRequests) {
            this.actual = actual;
            this.worker = worker;
            this.source = source;
            this.s = new AtomicReference();
            this.requested = new AtomicLong();
            this.nonScheduledRequests = nonScheduledRequests;
        }

        @Override
        public void run() {
            this.lazySet(Thread.currentThread());
            Publisher<T> src = this.source;
            this.source = null;
            src.subscribe(this);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            long r;
            if (SubscriptionHelper.setOnce(this.s, s2) && (r = this.requested.getAndSet(0L)) != 0L) {
                this.requestUpstream(r, s2);
            }
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
            this.worker.dispose();
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
            this.worker.dispose();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                Subscription s2 = this.s.get();
                if (s2 != null) {
                    this.requestUpstream(n, s2);
                } else {
                    long r;
                    BackpressureHelper.add(this.requested, n);
                    s2 = this.s.get();
                    if (s2 != null && (r = this.requested.getAndSet(0L)) != 0L) {
                        this.requestUpstream(r, s2);
                    }
                }
            }
        }

        void requestUpstream(final long n, final Subscription s2) {
            if (this.nonScheduledRequests || Thread.currentThread() == this.get()) {
                s2.request(n);
            } else {
                this.worker.schedule(new Runnable(){

                    @Override
                    public void run() {
                        s2.request(n);
                    }
                });
            }
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.s);
            this.worker.dispose();
        }
    }
}

