/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.operators.observable.ObservableScalarXMap;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableConcatMap<T, U>
extends AbstractObservableWithUpstream<T, U> {
    final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
    final int bufferSize;
    final ErrorMode delayErrors;

    public ObservableConcatMap(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends U>> mapper, int bufferSize, ErrorMode delayErrors) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.bufferSize = Math.max(8, bufferSize);
    }

    @Override
    public void subscribeActual(Observer<? super U> s2) {
        if (ObservableScalarXMap.tryScalarXMapSubscribe(this.source, s2, this.mapper)) {
            return;
        }
        if (this.delayErrors == ErrorMode.IMMEDIATE) {
            SerializedObserver<? super U> serial = new SerializedObserver<U>(s2);
            this.source.subscribe(new SourceObserver<T, U>(serial, this.mapper, this.bufferSize));
        } else {
            this.source.subscribe(new ConcatMapDelayErrorObserver<T, U>(s2, this.mapper, this.bufferSize, this.delayErrors == ErrorMode.END));
        }
    }

    static final class ConcatMapDelayErrorObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -6951100001833242599L;
        final Observer<? super R> actual;
        final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
        final int bufferSize;
        final AtomicThrowable error;
        final DelayErrorInnerObserver<R> observer;
        final SequentialDisposable arbiter;
        final boolean tillTheEnd;
        SimpleQueue<T> queue;
        Disposable d;
        volatile boolean active;
        volatile boolean done;
        volatile boolean cancelled;
        int sourceMode;

        ConcatMapDelayErrorObserver(Observer<? super R> actual, Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize, boolean tillTheEnd) {
            this.actual = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.tillTheEnd = tillTheEnd;
            this.error = new AtomicThrowable();
            this.observer = new DelayErrorInnerObserver<R>(actual, this);
            this.arbiter = new SequentialDisposable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                if (d instanceof QueueDisposable) {
                    QueueDisposable qd = (QueueDisposable)d;
                    int m3 = qd.requestFusion(3);
                    if (m3 == 1) {
                        this.sourceMode = m3;
                        this.queue = qd;
                        this.done = true;
                        this.actual.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m3 == 2) {
                        this.sourceMode = m3;
                        this.queue = qd;
                        this.actual.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new SpscLinkedArrayQueue(this.bufferSize);
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            if (this.sourceMode == 0) {
                this.queue.offer(value);
            }
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            if (this.error.addThrowable(e)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.d.dispose();
            this.arbiter.dispose();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Observer<R> actual = this.actual;
            SimpleQueue<T> queue = this.queue;
            AtomicThrowable error = this.error;
            while (true) {
                if (!this.active) {
                    boolean empty;
                    T v;
                    Throwable ex;
                    if (this.cancelled) {
                        queue.clear();
                        return;
                    }
                    if (!this.tillTheEnd && (ex = (Throwable)error.get()) != null) {
                        queue.clear();
                        actual.onError(error.terminate());
                        return;
                    }
                    boolean d = this.done;
                    try {
                        v = queue.poll();
                    }
                    catch (Throwable ex2) {
                        Exceptions.throwIfFatal(ex2);
                        this.d.dispose();
                        error.addThrowable(ex2);
                        actual.onError(error.terminate());
                        return;
                    }
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        Throwable ex3 = error.terminate();
                        if (ex3 != null) {
                            actual.onError(ex3);
                        } else {
                            actual.onComplete();
                        }
                        return;
                    }
                    if (!empty) {
                        ObservableSource<R> o;
                        try {
                            o = ObjectHelper.requireNonNull(this.mapper.apply(v), "The mapper returned a null ObservableSource");
                        }
                        catch (Throwable ex4) {
                            Exceptions.throwIfFatal(ex4);
                            this.d.dispose();
                            queue.clear();
                            error.addThrowable(ex4);
                            actual.onError(error.terminate());
                            return;
                        }
                        if (o instanceof Callable) {
                            Object w;
                            try {
                                w = ((Callable)((Object)o)).call();
                            }
                            catch (Throwable ex5) {
                                Exceptions.throwIfFatal(ex5);
                                error.addThrowable(ex5);
                                continue;
                            }
                            if (w == null || this.cancelled) continue;
                            actual.onNext(w);
                            continue;
                        }
                        this.active = true;
                        o.subscribe(this.observer);
                    }
                }
                if (this.decrementAndGet() == 0) break;
            }
        }

        static final class DelayErrorInnerObserver<R>
        implements Observer<R> {
            final Observer<? super R> actual;
            final ConcatMapDelayErrorObserver<?, R> parent;

            DelayErrorInnerObserver(Observer<? super R> actual, ConcatMapDelayErrorObserver<?, R> parent) {
                this.actual = actual;
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                this.parent.arbiter.replace(d);
            }

            @Override
            public void onNext(R value) {
                this.actual.onNext(value);
            }

            @Override
            public void onError(Throwable e) {
                ConcatMapDelayErrorObserver<?, R> p = this.parent;
                if (p.error.addThrowable(e)) {
                    if (!p.tillTheEnd) {
                        p.d.dispose();
                    }
                    p.active = false;
                    p.drain();
                } else {
                    RxJavaPlugins.onError(e);
                }
            }

            @Override
            public void onComplete() {
                ConcatMapDelayErrorObserver<?, R> p = this.parent;
                p.active = false;
                p.drain();
            }
        }
    }

    static final class SourceObserver<T, U>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 8828587559905699186L;
        final Observer<? super U> actual;
        final SequentialDisposable sa;
        final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
        final Observer<U> inner;
        final int bufferSize;
        SimpleQueue<T> queue;
        Disposable s;
        volatile boolean active;
        volatile boolean disposed;
        volatile boolean done;
        int fusionMode;

        SourceObserver(Observer<? super U> actual, Function<? super T, ? extends ObservableSource<? extends U>> mapper, int bufferSize) {
            this.actual = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.inner = new InnerObserver<U>(actual, this);
            this.sa = new SequentialDisposable();
        }

        @Override
        public void onSubscribe(Disposable s2) {
            if (DisposableHelper.validate(this.s, s2)) {
                this.s = s2;
                if (s2 instanceof QueueDisposable) {
                    QueueDisposable qd = (QueueDisposable)s2;
                    int m3 = qd.requestFusion(3);
                    if (m3 == 1) {
                        this.fusionMode = m3;
                        this.queue = qd;
                        this.done = true;
                        this.actual.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m3 == 2) {
                        this.fusionMode = m3;
                        this.queue = qd;
                        this.actual.onSubscribe(this);
                        return;
                    }
                }
                this.queue = new SpscLinkedArrayQueue(this.bufferSize);
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.fusionMode == 0) {
                this.queue.offer(t);
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.dispose();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.sa.dispose();
            this.s.dispose();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void innerSubscribe(Disposable s2) {
            this.sa.update(s2);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                ObservableSource<U> o;
                boolean empty;
                T t;
                if (this.disposed) {
                    this.queue.clear();
                    return;
                }
                if (this.active) continue;
                boolean d = this.done;
                try {
                    t = this.queue.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.dispose();
                    this.queue.clear();
                    this.actual.onError(ex);
                    return;
                }
                boolean bl = empty = t == null;
                if (d && empty) {
                    this.actual.onComplete();
                    return;
                }
                if (empty) continue;
                try {
                    o = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper returned a null ObservableSource");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.dispose();
                    this.queue.clear();
                    this.actual.onError(ex);
                    return;
                }
                this.active = true;
                o.subscribe(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        static final class InnerObserver<U>
        implements Observer<U> {
            final Observer<? super U> actual;
            final SourceObserver<?, ?> parent;

            InnerObserver(Observer<? super U> actual, SourceObserver<?, ?> parent) {
                this.actual = actual;
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable s2) {
                this.parent.innerSubscribe(s2);
            }

            @Override
            public void onNext(U t) {
                this.actual.onNext(t);
            }

            @Override
            public void onError(Throwable t) {
                this.parent.dispose();
                this.actual.onError(t);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }
        }
    }
}

