/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observers.SerializedObserver;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSampleWithObservable<T>
extends AbstractObservableWithUpstream<T, T> {
    final ObservableSource<?> other;

    public ObservableSampleWithObservable(ObservableSource<T> source, ObservableSource<?> other) {
        super(source);
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        SerializedObserver<? super T> serial = new SerializedObserver<T>(t);
        this.source.subscribe(new SampleMainObserver<T>(serial, this.other));
    }

    static final class SamplerObserver<T>
    implements Observer<Object> {
        final SampleMainObserver<T> parent;

        SamplerObserver(SampleMainObserver<T> parent) {
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Disposable s2) {
            this.parent.setOther(s2);
        }

        @Override
        public void onNext(Object t) {
            this.parent.emit();
        }

        @Override
        public void onError(Throwable t) {
            this.parent.error(t);
        }

        @Override
        public void onComplete() {
            this.parent.complete();
        }
    }

    static final class SampleMainObserver<T>
    extends AtomicReference<T>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -3517602651313910099L;
        final Observer<? super T> actual;
        final ObservableSource<?> sampler;
        final AtomicReference<Disposable> other = new AtomicReference();
        Disposable s;

        SampleMainObserver(Observer<? super T> actual, ObservableSource<?> other) {
            this.actual = actual;
            this.sampler = other;
        }

        @Override
        public void onSubscribe(Disposable s2) {
            if (DisposableHelper.validate(this.s, s2)) {
                this.s = s2;
                this.actual.onSubscribe(this);
                if (this.other.get() == null) {
                    this.sampler.subscribe(new SamplerObserver(this));
                }
            }
        }

        @Override
        public void onNext(T t) {
            this.lazySet(t);
        }

        @Override
        public void onError(Throwable t) {
            DisposableHelper.dispose(this.other);
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this.other);
            this.actual.onComplete();
        }

        boolean setOther(Disposable o) {
            return DisposableHelper.setOnce(this.other, o);
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.other);
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.other.get() == DisposableHelper.DISPOSED;
        }

        public void error(Throwable e) {
            this.s.dispose();
            this.actual.onError(e);
        }

        public void complete() {
            this.s.dispose();
            this.actual.onComplete();
        }

        public void emit() {
            Object value = this.getAndSet(null);
            if (value != null) {
                this.actual.onNext(value);
            }
        }
    }
}

