/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableTakeLastOne<T>
extends AbstractObservableWithUpstream<T, T> {
    public ObservableTakeLastOne(ObservableSource<T> source) {
        super(source);
    }

    @Override
    public void subscribeActual(Observer<? super T> s2) {
        this.source.subscribe(new TakeLastOneObserver<T>(s2));
    }

    static final class TakeLastOneObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> actual;
        Disposable s;
        T value;

        TakeLastOneObserver(Observer<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void onSubscribe(Disposable s2) {
            if (DisposableHelper.validate(this.s, s2)) {
                this.s = s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            this.value = t;
        }

        @Override
        public void onError(Throwable t) {
            this.value = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.emit();
        }

        void emit() {
            T v = this.value;
            if (v != null) {
                this.value = null;
                this.actual.onNext(v);
            }
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            this.value = null;
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }
    }
}

