/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.ArrayCompositeDisposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observers.SerializedObserver;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableTakeUntil<T, U>
extends AbstractObservableWithUpstream<T, T> {
    final ObservableSource<? extends U> other;

    public ObservableTakeUntil(ObservableSource<T> source, ObservableSource<? extends U> other) {
        super(source);
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super T> child) {
        final SerializedObserver<? super T> serial = new SerializedObserver<T>(child);
        final ArrayCompositeDisposable frc = new ArrayCompositeDisposable(2);
        TakeUntilObserver<? super T> tus = new TakeUntilObserver<T>(serial, frc);
        child.onSubscribe(frc);
        this.other.subscribe(new Observer<U>(){

            @Override
            public void onSubscribe(Disposable s2) {
                frc.setResource(1, s2);
            }

            @Override
            public void onNext(U t) {
                frc.dispose();
                serial.onComplete();
            }

            @Override
            public void onError(Throwable t) {
                frc.dispose();
                serial.onError(t);
            }

            @Override
            public void onComplete() {
                frc.dispose();
                serial.onComplete();
            }
        });
        this.source.subscribe(tus);
    }

    static final class TakeUntilObserver<T>
    extends AtomicBoolean
    implements Observer<T> {
        private static final long serialVersionUID = 3451719290311127173L;
        final Observer<? super T> actual;
        final ArrayCompositeDisposable frc;
        Disposable s;

        TakeUntilObserver(Observer<? super T> actual, ArrayCompositeDisposable frc) {
            this.actual = actual;
            this.frc = frc;
        }

        @Override
        public void onSubscribe(Disposable s2) {
            if (DisposableHelper.validate(this.s, s2)) {
                this.s = s2;
                this.frc.setResource(0, s2);
            }
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.frc.dispose();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.frc.dispose();
            this.actual.onComplete();
        }
    }
}

