/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.BasicIntQueueDisposable;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.Subject;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class UnicastSubject<T>
extends Subject<T> {
    final SpscLinkedArrayQueue<T> queue;
    final AtomicReference<Observer<? super T>> actual;
    final AtomicReference<Runnable> onTerminate;
    volatile boolean disposed;
    volatile boolean done;
    Throwable error;
    final AtomicBoolean once;
    final BasicIntQueueDisposable<T> wip;
    boolean enableOperatorFusion;

    public static <T> UnicastSubject<T> create() {
        return new UnicastSubject<T>(UnicastSubject.bufferSize());
    }

    public static <T> UnicastSubject<T> create(int capacityHint) {
        return new UnicastSubject<T>(capacityHint);
    }

    public static <T> UnicastSubject<T> create(int capacityHint, Runnable onCancelled) {
        return new UnicastSubject<T>(capacityHint, onCancelled);
    }

    UnicastSubject(int capacityHint) {
        this.queue = new SpscLinkedArrayQueue(ObjectHelper.verifyPositive(capacityHint, "capacityHint"));
        this.onTerminate = new AtomicReference();
        this.actual = new AtomicReference();
        this.once = new AtomicBoolean();
        this.wip = new UnicastQueueDisposable();
    }

    UnicastSubject(int capacityHint, Runnable onTerminate) {
        this.queue = new SpscLinkedArrayQueue(ObjectHelper.verifyPositive(capacityHint, "capacityHint"));
        this.onTerminate = new AtomicReference<Runnable>(ObjectHelper.requireNonNull(onTerminate, "onTerminate"));
        this.actual = new AtomicReference();
        this.once = new AtomicBoolean();
        this.wip = new UnicastQueueDisposable();
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            observer.onSubscribe(this.wip);
            this.actual.lazySet(observer);
            if (this.disposed) {
                this.actual.lazySet(null);
                return;
            }
            this.drain();
        } else {
            EmptyDisposable.error((Throwable)new IllegalStateException("Only a single observer allowed."), observer);
        }
    }

    void doTerminate() {
        Runnable r = this.onTerminate.get();
        if (r != null && this.onTerminate.compareAndSet(r, null)) {
            r.run();
        }
    }

    @Override
    public void onSubscribe(Disposable s2) {
        if (this.done || this.disposed) {
            s2.dispose();
        }
    }

    @Override
    public void onNext(T t) {
        if (this.done || this.disposed) {
            return;
        }
        if (t == null) {
            this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            return;
        }
        this.queue.offer(t);
        this.drain();
    }

    @Override
    public void onError(Throwable t) {
        if (this.done || this.disposed) {
            RxJavaPlugins.onError(t);
            return;
        }
        if (t == null) {
            t = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        this.error = t;
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    public void onComplete() {
        if (this.done || this.disposed) {
            return;
        }
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    void drainNormal(Observer<? super T> a) {
        int missed = 1;
        SpscLinkedArrayQueue<T> q = this.queue;
        while (true) {
            boolean empty;
            if (this.disposed) {
                this.actual.lazySet(null);
                q.clear();
                return;
            }
            boolean d = this.done;
            T v = this.queue.poll();
            boolean bl = empty = v == null;
            if (d && empty) {
                this.actual.lazySet(null);
                Throwable ex = this.error;
                if (ex != null) {
                    a.onError(ex);
                } else {
                    a.onComplete();
                }
                return;
            }
            if (!empty) {
                a.onNext(v);
                continue;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
        }
    }

    void drainFused(Observer<? super T> a) {
        int missed = 1;
        SpscLinkedArrayQueue<T> q = this.queue;
        do {
            if (this.disposed) {
                this.actual.lazySet(null);
                q.clear();
                return;
            }
            boolean d = this.done;
            a.onNext(null);
            if (!d) continue;
            this.actual.lazySet(null);
            Throwable ex = this.error;
            if (ex != null) {
                a.onError(ex);
            } else {
                a.onComplete();
            }
            return;
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        Observer<? super T> a = this.actual.get();
        int missed = 1;
        while (true) {
            if (a != null) {
                if (this.enableOperatorFusion) {
                    this.drainFused(a);
                } else {
                    this.drainNormal(a);
                }
                return;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            a = this.actual.get();
        }
    }

    @Override
    public boolean hasObservers() {
        return this.actual.get() != null;
    }

    @Override
    public Throwable getThrowable() {
        if (this.done) {
            return this.error;
        }
        return null;
    }

    @Override
    public boolean hasThrowable() {
        return this.done && this.error != null;
    }

    @Override
    public boolean hasComplete() {
        return this.done && this.error == null;
    }

    final class UnicastQueueDisposable
    extends BasicIntQueueDisposable<T> {
        private static final long serialVersionUID = 7926949470189395511L;

        UnicastQueueDisposable() {
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                UnicastSubject.this.enableOperatorFusion = true;
                return 2;
            }
            return 0;
        }

        @Override
        public T poll() throws Exception {
            return UnicastSubject.this.queue.poll();
        }

        @Override
        public boolean isEmpty() {
            return UnicastSubject.this.queue.isEmpty();
        }

        @Override
        public void clear() {
            UnicastSubject.this.queue.clear();
        }

        @Override
        public void dispose() {
            if (!UnicastSubject.this.disposed) {
                UnicastSubject.this.disposed = true;
                UnicastSubject.this.doTerminate();
                UnicastSubject.this.actual.lazySet(null);
                if (UnicastSubject.this.wip.getAndIncrement() == 0) {
                    UnicastSubject.this.actual.lazySet(null);
                    UnicastSubject.this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return UnicastSubject.this.disposed;
        }
    }
}

