/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.rxjava2;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;
import retrofit2.Response;
import retrofit2.adapter.rxjava2.HttpException;

final class BodyObservable<T>
extends Observable<T> {
    private final Observable<Response<T>> upstream;

    BodyObservable(Observable<Response<T>> upstream) {
        this.upstream = upstream;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.upstream.subscribe(new BodyObserver<T>(observer));
    }

    private static class BodyObserver<R>
    implements Observer<Response<R>> {
        private final Observer<? super R> observer;
        private boolean terminated;

        BodyObserver(Observer<? super R> observer) {
            this.observer = observer;
        }

        @Override
        public void onSubscribe(Disposable disposable) {
            this.observer.onSubscribe(disposable);
        }

        @Override
        public void onNext(Response<R> response) {
            if (response.isSuccessful()) {
                this.observer.onNext(response.body());
            } else {
                this.terminated = true;
                HttpException t = new HttpException(response);
                try {
                    this.observer.onError(t);
                }
                catch (Throwable inner) {
                    Exceptions.throwIfFatal(inner);
                    RxJavaPlugins.onError(new CompositeException(t, inner));
                }
            }
        }

        @Override
        public void onComplete() {
            if (!this.terminated) {
                this.observer.onComplete();
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (!this.terminated) {
                this.observer.onError(throwable);
            } else {
                AssertionError broken = new AssertionError((Object)"This should never happen! Report as a bug with the full stacktrace.");
                ((Throwable)((Object)broken)).initCause(throwable);
                RxJavaPlugins.onError((Throwable)((Object)broken));
            }
        }
    }
}

