/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.rxjava2;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;
import retrofit2.Call;
import retrofit2.Response;

final class CallExecuteObservable<T>
extends Observable<Response<T>> {
    private final Call<T> originalCall;

    CallExecuteObservable(Call<T> originalCall) {
        this.originalCall = originalCall;
    }

    @Override
    protected void subscribeActual(Observer<? super Response<T>> observer) {
        block8: {
            Call<T> call = this.originalCall.clone();
            CallDisposable disposable = new CallDisposable(call);
            observer.onSubscribe(disposable);
            if (disposable.isDisposed()) {
                return;
            }
            boolean terminated = false;
            try {
                Response<T> response = call.execute();
                if (!disposable.isDisposed()) {
                    observer.onNext(response);
                }
                if (!disposable.isDisposed()) {
                    terminated = true;
                    observer.onComplete();
                }
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                if (terminated) {
                    RxJavaPlugins.onError(t);
                }
                if (disposable.isDisposed()) break block8;
                try {
                    observer.onError(t);
                }
                catch (Throwable inner) {
                    Exceptions.throwIfFatal(inner);
                    RxJavaPlugins.onError(new CompositeException(t, inner));
                }
            }
        }
    }

    private static final class CallDisposable
    implements Disposable {
        private final Call<?> call;
        private volatile boolean disposed;

        CallDisposable(Call<?> call) {
            this.call = call;
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.call.cancel();
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

