/*
 * Decompiled with CFR 0.152.
 */
package com.technoguyfication.admingpt;

import com.technoguyfication.admingpt.openai.completion.chat.ChatCompletionRequest;
import com.technoguyfication.admingpt.openai.completion.chat.ChatCompletionResult;
import com.technoguyfication.admingpt.openai.completion.chat.ChatMessage;
import com.technoguyfication.admingpt.openai.completion.chat.ChatMessageRole;
import com.technoguyfication.admingpt.openai.service.OpenAiService;
import java.time.Duration;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventException;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AdminGPT
extends JavaPlugin
implements Listener {
    final int MAX_MESSAGES = 10;
    Pattern responsePattern = Pattern.compile("<([ctp])>\\/?(.*)<\\/[ctp]>");
    OpenAiService service;
    LinkedList<ChatMessage> messageHistory = new LinkedList();
    String systemPrompt;
    String languageModel;

    @Override
    public void onEnable() {
        FileConfiguration config = this.getConfig();
        String apiKey = config.getString("openai-api-key");
        if (apiKey == null || apiKey.isBlank()) {
            this.getLogger().severe("No OpenAI API key found in config.yml. Please add one and restart the server.");
            this.saveDefaultConfig();
            this.setEnabled(false);
            return;
        }
        this.systemPrompt = config.getString("openai-system-prompt");
        this.languageModel = config.getString("openai-language-model");
        this.service = new OpenAiService(apiKey, Duration.ofSeconds(15L));
        this.getServer().getPluginManager().registerEvents(this, this);
    }

    @Override
    public void onDisable() {
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) throws EventException {
        this.addChatMessage(new ChatMessage(ChatMessageRole.USER.value(), String.format("%s: %s", event.getPlayer().getName(), event.getMessage())));
        LinkedList<ChatMessage> messages = new LinkedList<ChatMessage>();
        messages.add(new ChatMessage(ChatMessageRole.SYSTEM.value(), this.systemPrompt));
        messages.addAll(this.messageHistory);
        ChatCompletionRequest request = ChatCompletionRequest.builder().model(this.languageModel).messages(messages).build();
        this.getLogger().fine("Sending chat completion request to OpenAI...");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            ChatCompletionResult result = this.service.createChatCompletion(request);
            ChatMessage responseMessage = result.getChoices().get(0).getMessage();
            this.getLogger().fine("Received chat completion result from OpenAI.");
            String command = null;
            String thoughts = null;
            String response = null;
            block10: for (String line : responseMessage.getContent().split("\\r?\\n")) {
                Matcher matcher = this.responsePattern.matcher(line);
                if (!matcher.find()) continue;
                switch (matcher.group(1)) {
                    case "c": {
                        command = matcher.group(2);
                        this.getLogger().info(String.format("Command: %s", command));
                        continue block10;
                    }
                    case "t": {
                        thoughts = matcher.group(2);
                        this.getLogger().info(String.format("Thoughts: %s", thoughts));
                        continue block10;
                    }
                    case "p": {
                        response = matcher.group(2);
                        this.getLogger().info(String.format("Response: %s", response));
                        continue block10;
                    }
                    default: {
                        this.getLogger().warning(String.format("Invalid response pattern: %s", line));
                    }
                }
            }
            String finalCommand = command;
            String finalResponse = response;
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                this.addChatMessage(responseMessage);
                if (finalCommand != null && !finalCommand.isBlank()) {
                    Bukkit.dispatchCommand(Bukkit.getConsoleSender(), finalCommand);
                }
                if (finalResponse != null && !finalResponse.isBlank()) {
                    Bukkit.broadcastMessage(ChatColor.AQUA + String.format("<AdminGPT> %s", finalResponse));
                }
            });
        });
    }

    private void addChatMessage(ChatMessage message) {
        if (this.messageHistory.size() >= 10) {
            this.messageHistory.removeFirst();
        }
        this.messageHistory.add(message);
    }
}

