/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;

public final class CompletableDisposeOn
extends Completable {
    final CompletableSource source;
    final Scheduler scheduler;

    public CompletableDisposeOn(CompletableSource source, Scheduler scheduler) {
        this.source = source;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(CompletableObserver s2) {
        this.source.subscribe(new CompletableObserverImplementation(s2, this.scheduler));
    }

    static final class CompletableObserverImplementation
    implements CompletableObserver,
    Disposable,
    Runnable {
        final CompletableObserver s;
        final Scheduler scheduler;
        Disposable d;
        volatile boolean disposed;

        CompletableObserverImplementation(CompletableObserver s2, Scheduler scheduler) {
            this.s = s2;
            this.scheduler = scheduler;
        }

        @Override
        public void onComplete() {
            if (this.disposed) {
                return;
            }
            this.s.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            if (this.disposed) {
                RxJavaPlugins.onError(e);
                return;
            }
            this.s.onError(e);
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.s.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.scheduler.scheduleDirect(this);
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void run() {
            this.d.dispose();
            this.d = DisposableHelper.DISPOSED;
        }
    }
}

