/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.Exceptions;
import java.util.concurrent.Callable;

public final class CompletableFromCallable
extends Completable {
    final Callable<?> callable;

    public CompletableFromCallable(Callable<?> callable) {
        this.callable = callable;
    }

    @Override
    protected void subscribeActual(CompletableObserver s2) {
        Disposable d = Disposables.empty();
        s2.onSubscribe(d);
        try {
            this.callable.call();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            if (!d.isDisposed()) {
                s2.onError(e);
            }
            return;
        }
        if (!d.isDisposed()) {
            s2.onComplete();
        }
    }
}

