/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;

public final class CompletableOnErrorComplete
extends Completable {
    final CompletableSource source;
    final Predicate<? super Throwable> predicate;

    public CompletableOnErrorComplete(CompletableSource source, Predicate<? super Throwable> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(final CompletableObserver s2) {
        this.source.subscribe(new CompletableObserver(){

            @Override
            public void onComplete() {
                s2.onComplete();
            }

            @Override
            public void onError(Throwable e) {
                boolean b;
                try {
                    b = CompletableOnErrorComplete.this.predicate.test(e);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    s2.onError(new CompositeException(e, ex));
                    return;
                }
                if (b) {
                    s2.onComplete();
                } else {
                    s2.onError(e);
                }
            }

            @Override
            public void onSubscribe(Disposable d) {
                s2.onSubscribe(d);
            }
        });
    }
}

