/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.plugins.RxJavaPlugins;

public final class CompletablePeek
extends Completable {
    final CompletableSource source;
    final Consumer<? super Disposable> onSubscribe;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Action onTerminate;
    final Action onAfterTerminate;
    final Action onDispose;

    public CompletablePeek(CompletableSource source, Consumer<? super Disposable> onSubscribe, Consumer<? super Throwable> onError, Action onComplete, Action onTerminate, Action onAfterTerminate, Action onDispose) {
        this.source = source;
        this.onSubscribe = onSubscribe;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onTerminate = onTerminate;
        this.onAfterTerminate = onAfterTerminate;
        this.onDispose = onDispose;
    }

    @Override
    protected void subscribeActual(final CompletableObserver s2) {
        this.source.subscribe(new CompletableObserver(){

            @Override
            public void onComplete() {
                try {
                    CompletablePeek.this.onComplete.run();
                    CompletablePeek.this.onTerminate.run();
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    s2.onError(e);
                    return;
                }
                s2.onComplete();
                this.doAfter();
            }

            @Override
            public void onError(Throwable e) {
                try {
                    CompletablePeek.this.onError.accept(e);
                    CompletablePeek.this.onTerminate.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    e = new CompositeException(e, ex);
                }
                s2.onError(e);
                this.doAfter();
            }

            @Override
            public void onSubscribe(final Disposable d) {
                try {
                    CompletablePeek.this.onSubscribe.accept(d);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    d.dispose();
                    EmptyDisposable.error(ex, s2);
                    return;
                }
                s2.onSubscribe(Disposables.fromRunnable(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CompletablePeek.this.onDispose.run();
                        }
                        catch (Throwable e) {
                            Exceptions.throwIfFatal(e);
                            RxJavaPlugins.onError(e);
                        }
                        d.dispose();
                    }
                }));
            }

            void doAfter() {
                try {
                    CompletablePeek.this.onAfterTerminate.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        });
    }
}

