/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.Iterator;
import org.reactivestreams.Subscriber;

public final class FlowableFromIterable<T>
extends Flowable<T> {
    final Iterable<? extends T> source;

    public FlowableFromIterable(Iterable<? extends T> source) {
        this.source = source;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        Iterator<? extends T> it;
        try {
            it = this.source.iterator();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptySubscription.error(e, s2);
            return;
        }
        FlowableFromIterable.subscribe(s2, it);
    }

    public static <T> void subscribe(Subscriber<? super T> s2, Iterator<? extends T> it) {
        boolean hasNext;
        try {
            hasNext = it.hasNext();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptySubscription.error(e, s2);
            return;
        }
        if (!hasNext) {
            EmptySubscription.complete(s2);
            return;
        }
        if (s2 instanceof ConditionalSubscriber) {
            s2.onSubscribe(new IteratorConditionalSubscription<T>((ConditionalSubscriber)s2, it));
        } else {
            s2.onSubscribe(new IteratorSubscription<T>(s2, it));
        }
    }

    static final class IteratorConditionalSubscription<T>
    extends BaseRangeSubscription<T> {
        private static final long serialVersionUID = -6022804456014692607L;
        final ConditionalSubscriber<? super T> actual;

        IteratorConditionalSubscription(ConditionalSubscriber<? super T> actual, Iterator<? extends T> it) {
            super(it);
            this.actual = actual;
        }

        @Override
        void fastPath() {
            boolean b;
            Iterator it = this.it;
            ConditionalSubscriber a = this.actual;
            do {
                Object t;
                if (this.cancelled) {
                    return;
                }
                try {
                    t = it.next();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    a.onError(ex);
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                if (t == null) {
                    a.onError(new NullPointerException("Iterator.next() returned a null value"));
                    return;
                }
                a.tryOnNext(t);
                if (this.cancelled) {
                    return;
                }
                try {
                    b = it.hasNext();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    a.onError(ex);
                    return;
                }
            } while (b);
            if (!this.cancelled) {
                a.onComplete();
            }
        }

        @Override
        void slowPath(long r) {
            long e = 0L;
            Iterator it = this.it;
            ConditionalSubscriber a = this.actual;
            while (true) {
                if (e != r) {
                    boolean hasNext;
                    Object t;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        t = it.next();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        a.onError(ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (t == null) {
                        a.onError(new NullPointerException("Iterator.next() returned a null value"));
                        return;
                    }
                    boolean b = a.tryOnNext(t);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        hasNext = it.hasNext();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        a.onError(ex);
                        return;
                    }
                    if (!hasNext) {
                        if (!this.cancelled) {
                            a.onComplete();
                        }
                        return;
                    }
                    if (!b) continue;
                    ++e;
                    continue;
                }
                r = this.get();
                if (e != r) continue;
                r = this.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }

    static final class IteratorSubscription<T>
    extends BaseRangeSubscription<T> {
        private static final long serialVersionUID = -6022804456014692607L;
        final Subscriber<? super T> actual;

        IteratorSubscription(Subscriber<? super T> actual, Iterator<? extends T> it) {
            super(it);
            this.actual = actual;
        }

        @Override
        void fastPath() {
            boolean b;
            Iterator it = this.it;
            Subscriber a = this.actual;
            do {
                Object t;
                if (this.cancelled) {
                    return;
                }
                try {
                    t = it.next();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    a.onError(ex);
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                if (t == null) {
                    a.onError(new NullPointerException("Iterator.next() returned a null value"));
                    return;
                }
                a.onNext(t);
                if (this.cancelled) {
                    return;
                }
                try {
                    b = it.hasNext();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    a.onError(ex);
                    return;
                }
            } while (b);
            if (!this.cancelled) {
                a.onComplete();
            }
        }

        @Override
        void slowPath(long r) {
            long e = 0L;
            Iterator it = this.it;
            Subscriber a = this.actual;
            while (true) {
                if (e != r) {
                    boolean b;
                    Object t;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        t = it.next();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        a.onError(ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (t == null) {
                        a.onError(new NullPointerException("Iterator.next() returned a null value"));
                        return;
                    }
                    a.onNext(t);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        b = it.hasNext();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        a.onError(ex);
                        return;
                    }
                    if (!b) {
                        if (!this.cancelled) {
                            a.onComplete();
                        }
                        return;
                    }
                    ++e;
                    continue;
                }
                r = this.get();
                if (e != r) continue;
                r = this.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }

    static abstract class BaseRangeSubscription<T>
    extends BasicQueueSubscription<T> {
        private static final long serialVersionUID = -2252972430506210021L;
        Iterator<? extends T> it;
        volatile boolean cancelled;
        boolean once;

        BaseRangeSubscription(Iterator<? extends T> it) {
            this.it = it;
        }

        @Override
        public final int requestFusion(int mode) {
            return mode & 1;
        }

        @Override
        public final T poll() {
            if (this.it == null) {
                return null;
            }
            if (!this.once) {
                this.once = true;
            } else if (!this.it.hasNext()) {
                return null;
            }
            return ObjectHelper.requireNonNull(this.it.next(), "Iterator.next() returned a null value");
        }

        @Override
        public final boolean isEmpty() {
            return this.it == null || !this.it.hasNext();
        }

        @Override
        public final void clear() {
            this.it = null;
        }

        @Override
        public final void request(long n) {
            if (SubscriptionHelper.validate(n) && BackpressureHelper.add(this, n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        @Override
        public final void cancel() {
            this.cancelled = true;
        }

        abstract void fastPath();

        abstract void slowPath(long var1);
    }
}

