/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Scheduler;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSampleTimed<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long period;
    final TimeUnit unit;
    final Scheduler scheduler;

    public FlowableSampleTimed(Publisher<T> source, long period, TimeUnit unit, Scheduler scheduler) {
        super(source);
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s2) {
        SerializedSubscriber<? super T> serial = new SerializedSubscriber<T>(s2);
        this.source.subscribe(new SampleTimedSubscriber<T>(serial, this.period, this.unit, this.scheduler));
    }

    static final class SampleTimedSubscriber<T>
    extends AtomicReference<T>
    implements Subscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -3517602651313910099L;
        final Subscriber<? super T> actual;
        final long period;
        final TimeUnit unit;
        final Scheduler scheduler;
        final AtomicLong requested = new AtomicLong();
        final SequentialDisposable timer = new SequentialDisposable();
        Subscription s;

        SampleTimedSubscriber(Subscriber<? super T> actual, long period, TimeUnit unit, Scheduler scheduler) {
            this.actual = actual;
            this.period = period;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.s, s2)) {
                this.s = s2;
                this.actual.onSubscribe(this);
                this.timer.replace(this.scheduler.schedulePeriodicallyDirect(this, this.period, this.period, this.unit));
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.lazySet(t);
        }

        @Override
        public void onError(Throwable t) {
            this.cancelTimer();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.cancelTimer();
            this.actual.onComplete();
        }

        void cancelTimer() {
            DisposableHelper.dispose(this.timer);
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
            }
        }

        @Override
        public void cancel() {
            this.cancelTimer();
            this.s.cancel();
        }

        @Override
        public void run() {
            Object value = this.getAndSet(null);
            if (value != null) {
                long r = this.requested.get();
                if (r != 0L) {
                    this.actual.onNext(value);
                    BackpressureHelper.produced(this.requested, 1L);
                } else {
                    this.cancel();
                    this.actual.onError(new MissingBackpressureException("Couldn't emit value due to lack of requests!"));
                }
            }
        }
    }
}

