/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableBuffer<T, U extends Collection<? super T>>
extends AbstractObservableWithUpstream<T, U> {
    final int count;
    final int skip;
    final Callable<U> bufferSupplier;

    public ObservableBuffer(ObservableSource<T> source, int count, int skip, Callable<U> bufferSupplier) {
        super(source);
        this.count = count;
        this.skip = skip;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t) {
        if (this.skip == this.count) {
            BufferExactObserver bes = new BufferExactObserver(t, this.count, this.bufferSupplier);
            if (bes.createBuffer()) {
                this.source.subscribe(bes);
            }
        } else {
            this.source.subscribe(new BufferSkipObserver(t, this.count, this.skip, this.bufferSupplier));
        }
    }

    static final class BufferSkipObserver<T, U extends Collection<? super T>>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -8223395059921494546L;
        final Observer<? super U> actual;
        final int count;
        final int skip;
        final Callable<U> bufferSupplier;
        Disposable s;
        final ArrayDeque<U> buffers;
        long index;

        BufferSkipObserver(Observer<? super U> actual, int count, int skip, Callable<U> bufferSupplier) {
            this.actual = actual;
            this.count = count;
            this.skip = skip;
            this.bufferSupplier = bufferSupplier;
            this.buffers = new ArrayDeque();
        }

        @Override
        public void onSubscribe(Disposable s2) {
            if (DisposableHelper.validate(this.s, s2)) {
                this.s = s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (this.index++ % (long)this.skip == 0L) {
                Collection b;
                try {
                    b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The bufferSupplier returned a null collection. Null values are generally not allowed in 2.x operators and sources.");
                }
                catch (Throwable e) {
                    this.buffers.clear();
                    this.s.dispose();
                    this.actual.onError(e);
                    return;
                }
                this.buffers.offer(b);
            }
            Iterator<U> it = this.buffers.iterator();
            while (it.hasNext()) {
                Collection b = (Collection)it.next();
                b.add(t);
                if (this.count > b.size()) continue;
                it.remove();
                this.actual.onNext(b);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.buffers.clear();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            while (!this.buffers.isEmpty()) {
                this.actual.onNext(this.buffers.poll());
            }
            this.actual.onComplete();
        }
    }

    static final class BufferExactObserver<T, U extends Collection<? super T>>
    implements Observer<T>,
    Disposable {
        final Observer<? super U> actual;
        final int count;
        final Callable<U> bufferSupplier;
        U buffer;
        int size;
        Disposable s;

        BufferExactObserver(Observer<? super U> actual, int count, Callable<U> bufferSupplier) {
            this.actual = actual;
            this.count = count;
            this.bufferSupplier = bufferSupplier;
        }

        boolean createBuffer() {
            Collection b;
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "Empty buffer supplied");
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                this.buffer = null;
                if (this.s == null) {
                    EmptyDisposable.error(t, this.actual);
                } else {
                    this.s.dispose();
                    this.actual.onError(t);
                }
                return false;
            }
            this.buffer = b;
            return true;
        }

        @Override
        public void onSubscribe(Disposable s2) {
            if (DisposableHelper.validate(this.s, s2)) {
                this.s = s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            U b = this.buffer;
            if (b != null) {
                b.add(t);
                if (++this.size >= this.count) {
                    this.actual.onNext(b);
                    this.size = 0;
                    this.createBuffer();
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            this.buffer = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            U b = this.buffer;
            this.buffer = null;
            if (b != null && !b.isEmpty()) {
                this.actual.onNext(b);
            }
            this.actual.onComplete();
        }
    }
}

