/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.plugins.RxJavaPlugins;

public final class ObservableElementAt<T>
extends AbstractObservableWithUpstream<T, T> {
    final long index;
    final T defaultValue;

    public ObservableElementAt(ObservableSource<T> source, long index, T defaultValue) {
        super(source);
        this.index = index;
        this.defaultValue = defaultValue;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new ElementAtObserver<T>(t, this.index, this.defaultValue));
    }

    static final class ElementAtObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> actual;
        final long index;
        final T defaultValue;
        Disposable s;
        long count;
        boolean done;

        ElementAtObserver(Observer<? super T> actual, long index, T defaultValue) {
            this.actual = actual;
            this.index = index;
            this.defaultValue = defaultValue;
        }

        @Override
        public void onSubscribe(Disposable s2) {
            if (DisposableHelper.validate(this.s, s2)) {
                this.s = s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            long c = this.count;
            if (c == this.index) {
                this.done = true;
                this.s.dispose();
                this.actual.onNext(t);
                this.actual.onComplete();
                return;
            }
            this.count = c + 1L;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                T v = this.defaultValue;
                if (v != null) {
                    this.actual.onNext(v);
                }
                this.actual.onComplete();
            }
        }
    }
}

