/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.BasicQueueDisposable;

public final class ObservableFromArray<T>
extends Observable<T> {
    final T[] array;

    public ObservableFromArray(T[] array) {
        this.array = array;
    }

    @Override
    public void subscribeActual(Observer<? super T> s2) {
        FromArrayDisposable<T> d = new FromArrayDisposable<T>(s2, this.array);
        s2.onSubscribe(d);
        if (d.fusionMode) {
            return;
        }
        d.run();
    }

    static final class FromArrayDisposable<T>
    extends BasicQueueDisposable<T> {
        final Observer<? super T> actual;
        final T[] array;
        int index;
        boolean fusionMode;
        volatile boolean disposed;

        FromArrayDisposable(Observer<? super T> actual, T[] array) {
            this.actual = actual;
            this.array = array;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 1) != 0) {
                this.fusionMode = true;
                return 1;
            }
            return 0;
        }

        @Override
        public T poll() {
            int i = this.index;
            T[] a = this.array;
            if (i != a.length) {
                this.index = i + 1;
                return ObjectHelper.requireNonNull(a[i], "The array element is null");
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.index == this.array.length;
        }

        @Override
        public void clear() {
            this.index = this.array.length;
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        void run() {
            T[] a = this.array;
            int n = a.length;
            for (int i = 0; i < n && !this.isDisposed(); ++i) {
                T value = a[i];
                if (value == null) {
                    this.actual.onError(new NullPointerException("The " + i + "th element is null"));
                    return;
                }
                this.actual.onNext(value);
            }
            if (!this.isDisposed()) {
                this.actual.onComplete();
            }
        }
    }
}

