/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.plugins.RxJavaPlugins;

public final class ObservableOnErrorNext<T>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier;
    final boolean allowFatal;

    public ObservableOnErrorNext(ObservableSource<T> source, Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier, boolean allowFatal) {
        super(source);
        this.nextSupplier = nextSupplier;
        this.allowFatal = allowFatal;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        OnErrorNextObserver<? super T> parent = new OnErrorNextObserver<T>(t, this.nextSupplier, this.allowFatal);
        t.onSubscribe(parent.arbiter);
        this.source.subscribe(parent);
    }

    static final class OnErrorNextObserver<T>
    implements Observer<T> {
        final Observer<? super T> actual;
        final Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier;
        final boolean allowFatal;
        final SequentialDisposable arbiter;
        boolean once;
        boolean done;

        OnErrorNextObserver(Observer<? super T> actual, Function<? super Throwable, ? extends ObservableSource<? extends T>> nextSupplier, boolean allowFatal) {
            this.actual = actual;
            this.nextSupplier = nextSupplier;
            this.allowFatal = allowFatal;
            this.arbiter = new SequentialDisposable();
        }

        @Override
        public void onSubscribe(Disposable s2) {
            this.arbiter.replace(s2);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            ObservableSource<T> p;
            if (this.once) {
                if (this.done) {
                    RxJavaPlugins.onError(t);
                    return;
                }
                this.actual.onError(t);
                return;
            }
            this.once = true;
            if (this.allowFatal && !(t instanceof Exception)) {
                this.actual.onError(t);
                return;
            }
            try {
                p = this.nextSupplier.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(new CompositeException(t, e));
                return;
            }
            if (p == null) {
                NullPointerException npe = new NullPointerException("Observable is null");
                npe.initCause(t);
                this.actual.onError(npe);
                return;
            }
            p.subscribe(this);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.once = true;
            this.actual.onComplete();
        }
    }
}

