/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.plugins.RxJavaPlugins;

public final class ObservableTake<T>
extends AbstractObservableWithUpstream<T, T> {
    final long limit;

    public ObservableTake(ObservableSource<T> source, long limit) {
        super(source);
        this.limit = limit;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new TakeObserver<T>(observer, this.limit));
    }

    static final class TakeObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> actual;
        boolean done;
        Disposable subscription;
        long remaining;

        TakeObserver(Observer<? super T> actual, long limit) {
            this.actual = actual;
            this.remaining = limit;
        }

        @Override
        public void onSubscribe(Disposable s2) {
            if (DisposableHelper.validate(this.subscription, s2)) {
                this.subscription = s2;
                if (this.remaining == 0L) {
                    this.done = true;
                    s2.dispose();
                    EmptyDisposable.complete(this.actual);
                } else {
                    this.actual.onSubscribe(this);
                }
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.done && this.remaining-- > 0L) {
                boolean stop = this.remaining == 0L;
                this.actual.onNext(t);
                if (stop) {
                    this.onComplete();
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.subscription.dispose();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.subscription.dispose();
                this.actual.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.subscription.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.subscription.isDisposed();
        }
    }
}

