/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observers.SerializedObserver;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableWithLatestFrom<T, U, R>
extends AbstractObservableWithUpstream<T, R> {
    final BiFunction<? super T, ? super U, ? extends R> combiner;
    final ObservableSource<? extends U> other;

    public ObservableWithLatestFrom(ObservableSource<T> source, BiFunction<? super T, ? super U, ? extends R> combiner, ObservableSource<? extends U> other) {
        super(source);
        this.combiner = combiner;
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super R> t) {
        SerializedObserver<? super R> serial = new SerializedObserver<R>(t);
        final WithLatestFromObserver<? super T, ? super U, ? extends R> wlf = new WithLatestFromObserver<T, U, R>(serial, this.combiner);
        t.onSubscribe(wlf);
        this.other.subscribe(new Observer<U>(){

            @Override
            public void onSubscribe(Disposable s2) {
                wlf.setOther(s2);
            }

            @Override
            public void onNext(U t) {
                wlf.lazySet(t);
            }

            @Override
            public void onError(Throwable t) {
                wlf.otherError(t);
            }

            @Override
            public void onComplete() {
            }
        });
        this.source.subscribe(wlf);
    }

    static final class WithLatestFromObserver<T, U, R>
    extends AtomicReference<U>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -312246233408980075L;
        final Observer<? super R> actual;
        final BiFunction<? super T, ? super U, ? extends R> combiner;
        final AtomicReference<Disposable> s = new AtomicReference();
        final AtomicReference<Disposable> other = new AtomicReference();

        WithLatestFromObserver(Observer<? super R> actual, BiFunction<? super T, ? super U, ? extends R> combiner) {
            this.actual = actual;
            this.combiner = combiner;
        }

        @Override
        public void onSubscribe(Disposable s2) {
            DisposableHelper.setOnce(this.s, s2);
        }

        @Override
        public void onNext(T t) {
            Object u = this.get();
            if (u != null) {
                R r;
                try {
                    r = this.combiner.apply(t, u);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.dispose();
                    this.actual.onError(e);
                    return;
                }
                this.actual.onNext(r);
            }
        }

        @Override
        public void onError(Throwable t) {
            DisposableHelper.dispose(this.other);
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this.other);
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.s);
            DisposableHelper.dispose(this.other);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.s.get());
        }

        public boolean setOther(Disposable o) {
            return DisposableHelper.setOnce(this.other, o);
        }

        public void otherError(Throwable e) {
            DisposableHelper.dispose(this.s);
            this.actual.onError(e);
        }
    }
}

