/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

public final class SingleEquals<T>
extends Single<Boolean> {
    final SingleSource<? extends T> first;
    final SingleSource<? extends T> second;

    public SingleEquals(SingleSource<? extends T> first, SingleSource<? extends T> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super Boolean> s2) {
        final AtomicInteger count = new AtomicInteger();
        final Object[] values = new Object[]{null, null};
        final CompositeDisposable set = new CompositeDisposable();
        s2.onSubscribe(set);
        class InnerObserver
        implements SingleObserver<T> {
            final int index;

            InnerObserver(int index) {
                this.index = index;
            }

            @Override
            public void onSubscribe(Disposable d) {
                set.add(d);
            }

            @Override
            public void onSuccess(T value) {
                values[this.index] = value;
                if (count.incrementAndGet() == 2) {
                    s2.onSuccess(ObjectHelper.equals(values[0], values[1]));
                }
            }

            @Override
            public void onError(Throwable e) {
                int state;
                do {
                    if ((state = count.get()) < 2) continue;
                    RxJavaPlugins.onError(e);
                    return;
                } while (!count.compareAndSet(state, 2));
                set.dispose();
                s2.onError(e);
            }
        }
        this.first.subscribe(new InnerObserver(0));
        this.second.subscribe(new InnerObserver(1));
    }
}

