/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Flowable;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;

public final class SingleFlatMapIterableFlowable<T, R>
extends Flowable<R> {
    final SingleSource<T> source;
    final Function<? super T, ? extends Iterable<? extends R>> mapper;

    public SingleFlatMapIterableFlowable(SingleSource<T> source, Function<? super T, ? extends Iterable<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s2) {
        this.source.subscribe(new FlatMapIterableObserver<T, R>(s2, this.mapper));
    }

    static final class FlatMapIterableObserver<T, R>
    extends BasicIntQueueSubscription<R>
    implements SingleObserver<T> {
        private static final long serialVersionUID = -8938804753851907758L;
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends Iterable<? extends R>> mapper;
        final AtomicLong requested;
        Disposable d;
        volatile Iterator<? extends R> it;
        volatile boolean cancelled;
        boolean outputFused;

        FlatMapIterableObserver(Subscriber<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper) {
            this.actual = actual;
            this.mapper = mapper;
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            boolean has;
            Iterator<R> iter;
            try {
                iter = this.mapper.apply(value).iterator();
                has = iter.hasNext();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.actual.onError(ex);
                return;
            }
            if (!has) {
                this.actual.onComplete();
                return;
            }
            this.it = iter;
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            this.d = DisposableHelper.DISPOSED;
            this.actual.onError(e);
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.d.dispose();
            this.d = DisposableHelper.DISPOSED;
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<R> a = this.actual;
            Iterator<R> iter = this.it;
            if (this.outputFused && iter != null) {
                a.onNext(null);
                a.onComplete();
                return;
            }
            int missed = 1;
            while (true) {
                if (iter != null) {
                    long e;
                    long r = this.requested.get();
                    if (r == Long.MAX_VALUE) {
                        this.slowPath(a, iter);
                        return;
                    }
                    for (e = 0L; e != r; ++e) {
                        R v;
                        if (this.cancelled) {
                            return;
                        }
                        try {
                            v = ObjectHelper.requireNonNull(iter.next(), "The iterator returned a null value");
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            a.onError(ex);
                            return;
                        }
                        a.onNext(v);
                        if (this.cancelled) {
                            return;
                        }
                        try {
                            boolean b = iter.hasNext();
                            continue;
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            a.onError(ex);
                            return;
                        }
                    }
                    if (e != 0L) {
                        BackpressureHelper.produced(this.requested, e);
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (iter != null) continue;
                iter = this.it;
            }
        }

        void slowPath(Subscriber<? super R> a, Iterator<? extends R> iter) {
            boolean b;
            do {
                R v;
                if (this.cancelled) {
                    return;
                }
                try {
                    v = iter.next();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    a.onError(ex);
                    return;
                }
                a.onNext(v);
                if (this.cancelled) {
                    return;
                }
                try {
                    b = iter.hasNext();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    a.onError(ex);
                    return;
                }
            } while (b);
            a.onComplete();
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        public void clear() {
            this.it = null;
        }

        @Override
        public boolean isEmpty() {
            return this.it == null;
        }

        @Override
        public R poll() throws Exception {
            Iterator<R> iter = this.it;
            if (iter != null) {
                R v = ObjectHelper.requireNonNull(iter.next(), "The iterator returned a null value");
                if (!iter.hasNext()) {
                    this.it = null;
                }
                return v;
            }
            return null;
        }
    }
}

