/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscriptions;

import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscriber;

public final class ScalarSubscription<T>
extends AtomicInteger
implements QueueSubscription<T> {
    private static final long serialVersionUID = -3830916580126663321L;
    final T value;
    final Subscriber<? super T> subscriber;
    static final int NO_REQUEST = 0;
    static final int REQUESTED = 1;
    static final int CANCELLED = 2;

    public ScalarSubscription(Subscriber<? super T> subscriber, T value) {
        this.subscriber = subscriber;
        this.value = value;
    }

    @Override
    public void request(long n) {
        if (!SubscriptionHelper.validate(n)) {
            return;
        }
        if (this.compareAndSet(0, 1)) {
            Subscriber<T> s2 = this.subscriber;
            s2.onNext(this.value);
            if (this.get() != 2) {
                s2.onComplete();
            }
        }
    }

    @Override
    public void cancel() {
        this.lazySet(2);
    }

    public boolean isCancelled() {
        return this.get() == 2;
    }

    @Override
    public boolean offer(T e) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Override
    public boolean offer(T v1, T v2) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Override
    public T poll() {
        if (this.get() == 0) {
            this.lazySet(1);
            return this.value;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.get() != 0;
    }

    @Override
    public void clear() {
        this.lazySet(1);
    }

    @Override
    public int requestFusion(int mode) {
        return mode & 1;
    }
}

