/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.observers;

import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.ListCompositeDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ResourceSingleObserver<T>
implements SingleObserver<T>,
Disposable {
    private final AtomicReference<Disposable> s = new AtomicReference();
    private final ListCompositeDisposable resources = new ListCompositeDisposable();

    public final void add(Disposable resource) {
        ObjectHelper.requireNonNull(resource, "resource is null");
        this.resources.add(resource);
    }

    @Override
    public final void onSubscribe(Disposable s2) {
        if (DisposableHelper.setOnce(this.s, s2)) {
            this.onStart();
        }
    }

    protected void onStart() {
    }

    @Override
    public final void dispose() {
        if (DisposableHelper.dispose(this.s)) {
            this.resources.dispose();
        }
    }

    @Override
    public final boolean isDisposed() {
        return DisposableHelper.isDisposed(this.s.get());
    }
}

