/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.schedulers;

import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.TimeUnit;

public final class Timed<T> {
    final T value;
    final long time;
    final TimeUnit unit;

    public Timed(T value, long time, TimeUnit unit) {
        this.value = value;
        this.time = time;
        this.unit = ObjectHelper.requireNonNull(unit, "unit is null");
    }

    public T value() {
        return this.value;
    }

    public TimeUnit unit() {
        return this.unit;
    }

    public long time() {
        return this.time;
    }

    public long time(TimeUnit unit) {
        return unit.convert(this.time, this.unit);
    }

    public boolean equals(Object other) {
        if (other instanceof Timed) {
            Timed o = (Timed)other;
            return ObjectHelper.equals(this.value, o.value) && this.time == o.time && ObjectHelper.equals((Object)this.unit, (Object)o.unit);
        }
        return false;
    }

    public int hashCode() {
        int h2 = this.value != null ? this.value.hashCode() : 0;
        h2 = h2 * 31 + (int)(this.time >>> 31 ^ this.time);
        h2 = h2 * 31 + this.unit.hashCode();
        return h2;
    }

    public String toString() {
        return "Timed[time=" + this.time + ", unit=" + (Object)((Object)this.unit) + ", value=" + this.value + "]";
    }
}

