package de.greenman999.fullbright;

import dev.isxander.yacl3.api.*;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleSliderControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_6599;

public class FConfig {

    public static ConfigClassHandler<FConfig> HANDLER = ConfigClassHandler.createBuilder(FConfig.class)
            .id(class_2960.method_60655("fullbright", "fconfig"))
            .serializer(config -> GsonConfigSerializerBuilder.create(config)
                    .setPath(FabricLoader.getInstance().getConfigDir().resolve("fullbright.json5"))
                    .setJson5(true)
                    .build())
            .build();

    @SerialEntry
    public static boolean enabled = false;

    @SerialEntry
    public static double defaultBrightness = 0.5;

    @SerialEntry
    public static double brightness = 100.0;

    public static class_437 openConfigScreen(class_437 parent) {
        return YetAnotherConfigLib.createBuilder()
                .title(class_2561.method_43471("fullbright.config.title"))
                .category(ConfigCategory.createBuilder()
                        .name(class_2561.method_43471("fullbright.config.categories.main.name"))
                        .option(Option.<Boolean>createBuilder()
                                .name(class_2561.method_43471("fullbright.config.categories.main.options.enabled.name"))
                                .description(OptionDescription.of(class_2561.method_43471("fullbright.config.categories.main.options.enabled.description")))
                                .binding(false, () -> FConfig.enabled, FullbrightMod::setFullbright)
                                .controller(opt -> BooleanControllerBuilder.create(opt)
                                        .coloured(true)
                                        .yesNoFormatter())
                                .build())
                        .option(Option.<Double>createBuilder()
                                .name(class_2561.method_43471("fullbright.config.categories.main.options.brightness.name"))
                                .description(OptionDescription.of(class_2561.method_43471("fullbright.config.categories.main.options.brightness.description")))
                                .binding(100.0, () -> FConfig.brightness, newVal -> FConfig.brightness = newVal)
                                .controller(opt -> DoubleSliderControllerBuilder.create(opt)
                                        .range(0.0, 100.0)
                                        .step(1.0))
                                .build())
                        .option(Option.<Double>createBuilder()
                                .name(class_2561.method_43471("fullbright.config.categories.main.options.default-brightness.name"))
                                .description(OptionDescription.of(class_2561.method_43471("fullbright.config.categories.main.options.default-brightness.description")))
                                .binding(0.5, () -> FConfig.defaultBrightness, newVal -> FConfig.defaultBrightness = newVal)
                                .controller(opt -> DoubleSliderControllerBuilder.create(opt)
                                        .range(0.0, 1.0)
                                        .step(0.1))
                                .build())
                        .option(LabelOption.createBuilder()
                                .line(class_2561.method_43469("fullbright.config.categories.main.options.keybindings", FullbrightMod.keyBinding.method_16007()))
                                .line(class_2561.method_43471("fullbright.config.categories.main.options.keybindings.notice").method_27692(class_124.field_1080))
                                .build())
                        .option(ButtonOption.createBuilder()
                                .name(class_2561.method_43471("fullbright.config.categories.main.options.open-controls.name"))
                                .description(OptionDescription.of(class_2561.method_43471("fullbright.config.categories.main.options.open-controls.description")))
                                .text(class_2561.method_43473())
                                .action((screen, opt) -> class_310.method_1551().method_1507(new class_6599(parent, class_310.method_1551().field_1690)))
                                .build())
                        .build())
                .build().generateScreen(parent);
    }
}
