package de.greenman999.fullbright;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.argument;
import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.literal;

public class FullbrightMod implements ClientModInitializer {

	public static final Logger LOGGER = LoggerFactory.getLogger("fullbright");

	public static class_304 keyBinding;
	private boolean loaded = false;
	private final ModMenuApiImpl modMenuApi = new ModMenuApiImpl();
	private boolean openConfigScreen = false;

	@Override
	public void onInitializeClient() {
		LOGGER.info("Loaded Fullbright Mod!");
		FConfig.HANDLER.load();

		keyBinding = KeyBindingHelper.registerKeyBinding(new class_304(
				"key.fullbright.toggle",
				class_3675.class_307.field_1668,
				GLFW.GLFW_KEY_B,
				class_304.class_11900.method_74698(class_2960.method_60655("fullbright", "main"))
		));

		ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) ->
				dispatcher.register(literal("fullbright-config")
						.executes(context -> {
							openConfigScreen = true;
							return 1;
						})
				));

		ClientTickEvents.END_CLIENT_TICK.register(client -> {
			if(!loaded && class_310.method_1551().field_1690 != null) {
				loaded = true;
				if(FConfig.enabled) enableFullbright();
			}
			if(openConfigScreen) {
				openConfigScreen = false;
				class_310.method_1551().method_1507(FConfig.openConfigScreen(class_310.method_1551().field_1755));
			}
			while (keyBinding.method_1436()) {
				toggleFullbright();
			}
		});
	}

	public static void enableFullbright() {
		class_310.method_1551().field_1690.method_42473().method_41748(FConfig.brightness);
		FConfig.enabled = true;
	}

	public static void disableFullbright() {
		class_310.method_1551().field_1690.method_42473().method_41748(FConfig.defaultBrightness);
		FConfig.enabled = false;
	}

	public void toggleFullbright() {
		if (FConfig.enabled) {
			disableFullbright();
		} else {
			enableFullbright();
		}
		FConfig.HANDLER.save();
	}

	public static void setFullbright(boolean enabled) {
		if (enabled) {
			enableFullbright();
		} else {
			disableFullbright();
		}
		FConfig.HANDLER.save();
	}
}
