/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils;

import dev.eposs.elementsutils.ElementsUtils;
import dev.eposs.elementsutils.config.ModConfig;
import dev.eposs.elementsutils.feature.bosstimer.BossTimerData;
import dev.eposs.elementsutils.feature.bosstimer.BossTimerDisplay;
import dev.eposs.elementsutils.feature.excaliburtimer.ExcaliburTimerData;
import dev.eposs.elementsutils.feature.excaliburtimer.ExcaliburTimerDisplay;
import dev.eposs.elementsutils.feature.loot.LootSound;
import dev.eposs.elementsutils.feature.pet.PetDisplay;
import dev.eposs.elementsutils.feature.playerbase.BaseBorderDisplay;
import dev.eposs.elementsutils.feature.potion.PotionDisplay;
import dev.eposs.elementsutils.feature.xpmeter.XpMeter;
import dev.eposs.elementsutils.rendering.ScreenRendering;
import dev.eposs.elementsutils.util.DevUtil;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_642;
import net.minecraft.class_7225;
import org.apache.commons.codec.digest.DigestUtils;

@Environment(value=EnvType.CLIENT)
public class ElementsUtilsClient
implements ClientModInitializer {
    private static class_304 baseDisplayToggle;
    private static class_304 bossTimerToggle;
    private static class_304 excaliburTimeToggle;
    private static class_304 xpMeasureTrigger;
    private static class_304 timeMeasureTrigger;
    private static class_304 devUtils;

    public void onInitializeClient() {
        AutoConfig.register(ModConfig.class, Toml4jConfigSerializer::new);
        this.registerKeyBinding();
        this.registerEvents();
        ExcaliburTimerData.startUpdateTimers();
        BossTimerData.startUpdateTimers();
    }

    private void registerEvents() {
        HudLayerRegistrationCallback.EVENT.register(ScreenRendering::register);
        WorldRenderEvents.LAST.register(BaseBorderDisplay::render);
        ClientPlayConnectionEvents.JOIN.register(this::onJoin);
        ClientPlayConnectionEvents.DISCONNECT.register(this::onLeave);
        ClientTickEvents.END_CLIENT_TICK.register(this::clientTick);
        ClientReceiveMessageEvents.ALLOW_GAME.register(this::onGameMessage);
    }

    private void clientTick(class_310 client) {
        this.onKeyEvent(client);
        PetDisplay.updatePet(client);
        PotionDisplay.updatePotions(client);
        XpMeter.updateXpMeter(client);
    }

    private void onJoin(class_634 handler, PacketSender sender, class_310 client) {
        this.runServerCheck(client);
        ModConfig.InternalConfig.Servers server = ModConfig.getConfig().internal.server;
        if (server != ModConfig.InternalConfig.Servers.UNKNOWN) {
            PetDisplay.loadPet((class_7225.class_7874)handler.method_29091());
            BossTimerData.updateData();
            ExcaliburTimerData.updateData();
        }
    }

    private void onLeave(class_634 handler, class_310 client) {
        PetDisplay.savePet();
    }

    private void runServerCheck(class_310 client) {
        class_642 serverEntry = client.method_1558();
        if (serverEntry == null) {
            return;
        }
        String server1 = "d2228bebe6cb6b55feb3258bc4aff39ffa41b6222a145951ba88916af1706553";
        String server2 = "1f4492b5647f7b11ebd28bc0bcea28bddebe39d83961803c9038ece28defda70";
        String hash = DigestUtils.sha3_256Hex((String)serverEntry.field_3761);
        if (hash.equals(server1)) {
            ModConfig.getConfig().internal.server = ModConfig.InternalConfig.Servers.COMMUNITY_SERVER_1;
            ModConfig.save();
            ElementsUtils.LOGGER.info("Detected elements community server 1");
        } else if (hash.equals(server2)) {
            ModConfig.getConfig().internal.server = ModConfig.InternalConfig.Servers.COMMUNITY_SERVER_2;
            ModConfig.save();
            ElementsUtils.LOGGER.info("Detected elements community server 2");
        } else {
            ElementsUtils.LOGGER.warn("Unable to detect elements community server");
        }
    }

    private boolean onGameMessage(class_2561 text, boolean b) {
        LootSound.onGameMessage(text);
        return true;
    }

    private void registerKeyBinding() {
        String category = "category.elements-utils.keys";
        baseDisplayToggle = KeyBindingHelper.registerKeyBinding((class_304)new class_304(this.getKeyBindingTranslation("baseDisplayToggle"), 90, category));
        bossTimerToggle = KeyBindingHelper.registerKeyBinding((class_304)new class_304(this.getKeyBindingTranslation("bossTimerToggle"), 86, category));
        excaliburTimeToggle = KeyBindingHelper.registerKeyBinding((class_304)new class_304(this.getKeyBindingTranslation("excaliburTimeToggle"), -1, category));
        xpMeasureTrigger = KeyBindingHelper.registerKeyBinding((class_304)new class_304(this.getKeyBindingTranslation("xpMeasureTrigger"), -1, category));
        timeMeasureTrigger = KeyBindingHelper.registerKeyBinding((class_304)new class_304(this.getKeyBindingTranslation("timeMeasureTrigger"), -1, category));
        devUtils = KeyBindingHelper.registerKeyBinding((class_304)new class_304(this.getKeyBindingTranslation("devUtils"), -1, category));
    }

    private void onKeyEvent(class_310 client) {
        while (baseDisplayToggle.method_1436()) {
            BaseBorderDisplay.toggleDisplay(client);
        }
        while (bossTimerToggle.method_1436()) {
            BossTimerDisplay.toggleDisplay(client);
        }
        while (excaliburTimeToggle.method_1436()) {
            ExcaliburTimerDisplay.toggleDisplay(client);
        }
        while (xpMeasureTrigger.method_1436()) {
            XpMeter.startXPMeasurement(client);
        }
        while (timeMeasureTrigger.method_1436()) {
            XpMeter.startTimeMeasurement(client);
        }
        while (devUtils.method_1436()) {
            DevUtil.doSomething(client);
        }
    }

    private String getKeyBindingTranslation(String keyBinding) {
        return "key.elements-utils." + keyBinding;
    }
}

