/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.api.timer;

import com.google.gson.Gson;
import dev.eposs.elementsutils.ElementsUtils;
import dev.eposs.elementsutils.config.ModConfig;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractTimerApi<T> {
    private final Class<T> type;
    private final String apiUrl;

    public AbstractTimerApi(Class<T> type, String apiUrl) {
        this.type = type;
        this.apiUrl = apiUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T getTimerData() {
        String serverID;
        switch (ModConfig.getConfig().internal.server) {
            case COMMUNITY_SERVER_1: {
                serverID = "server1";
                break;
            }
            case COMMUNITY_SERVER_2: {
                serverID = "server2";
                break;
            }
            default: {
                return null;
            }
        }
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.apiUrl.replace("$SERVER_ID", serverID))).GET().build();
        try (HttpClient client = HttpClient.newBuilder().build();){
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IOException("Status code " + response.statusCode() + " - " + response.body());
            }
            Object object = new Gson().fromJson(response.body(), this.type);
            return (T)object;
        }
        catch (Exception e) {
            ElementsUtils.LOGGER.error("Failed to get timer data", (Throwable)e);
            return null;
        }
    }
}

