/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.config;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Config(name="elements-utils")
@Environment(value=EnvType.CLIENT)
public class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public InternalConfig internal = new InternalConfig();
    public boolean showMoonPhaseDisplay = true;
    public boolean showTimeDisplay = true;
    public boolean showPetDisplay = true;
    public Position displayPosition = Position.TOP_RIGHT;
    @ConfigEntry.Gui.CollapsibleObject
    public BossTimerConfig bossTimer = new BossTimerConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public ExcaliburTimeConfig excaliburTime = new ExcaliburTimeConfig();
    public boolean playLootSound = true;
    public boolean showBaseDisplay = false;
    @ConfigEntry.Gui.CollapsibleObject
    public PotionDisplayConfig potionDisplay = new PotionDisplayConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public XPMeterConfig xpMeterConfig = new XPMeterConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public PlayerLevelConfig playerLevelConfig = new PlayerLevelConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public PlayerXPConfig playerXPConfig = new PlayerXPConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public DevUtilsConfig devUtils = new DevUtilsConfig();

    public static ModConfig getConfig() {
        return (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
    }

    public static void save() {
        AutoConfig.getConfigHolder(ModConfig.class).save();
    }

    @Environment(value=EnvType.CLIENT)
    public static class InternalConfig {
        public Servers server = Servers.UNKNOWN;
        public PetData petData = new PetData();

        @Environment(value=EnvType.CLIENT)
        public static enum Servers {
            UNKNOWN,
            COMMUNITY_SERVER_1,
            COMMUNITY_SERVER_2;

        }

        @Environment(value=EnvType.CLIENT)
        public static class PetData {
            public String data;
            public int currentXP;
            public int nextLvlXP;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    @Environment(value=EnvType.CLIENT)
    public static class BossTimerConfig {
        public boolean show = true;
        public boolean textOutline = true;
        public TimeFormat bossTimeFormat = TimeFormat.RELATIVE;
        public boolean colorBossNames = true;
        public boolean colorBossTime = true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class ExcaliburTimeConfig {
        public boolean show = true;
        public boolean textOutline = true;
        public boolean colorExcaliburNames = true;
        public boolean colorExcaliburTime = true;
        public TimeFormat excaliburTimeFormat = TimeFormat.ABSOLUTE;
    }

    @Environment(value=EnvType.CLIENT)
    public static class PotionDisplayConfig {
        public boolean show = true;
        public Position position = Position.RIGHT;

        @Environment(value=EnvType.CLIENT)
        public static enum Position {
            LEFT,
            RIGHT;

        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class XPMeterConfig {
        public Integer measuringXpTarget = 500;
        public Integer measuringTimeTarget = 300;
    }

    @Environment(value=EnvType.CLIENT)
    public static class PlayerLevelConfig {
        public boolean enabled = true;
        public KnownColor formattedPlayerLevelColor = KnownColor.EXPERIENCE_GREEN;
        public KnownColor formattedPlayerListLevelColor = KnownColor.YELLOW;
    }

    @Environment(value=EnvType.CLIENT)
    public static class PlayerXPConfig {
        public boolean enabled = true;
        public boolean showXpPerSecond = false;
        public KnownColor xpPerSecondColor = KnownColor.GRAY;
        public KnownColor overlayMessageColor = KnownColor.DARK_AQUA;
        public boolean hideMaxPetXP = false;
        public int overlayMessageYOffset = 0;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DevUtilsConfig {
        public boolean enable = false;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum KnownColor {
        BLACK(0),
        DARK_BLUE(170),
        DARK_GREEN(43520),
        DARK_AQUA(43690),
        DARK_RED(0xAA0000),
        DARK_PURPLE(0xAA00AA),
        GOLD(0xFFAA00),
        GRAY(0xAAAAAA),
        DARK_GRAY(0x555555),
        BLUE(0x5555FF),
        GREEN(0x55FF55),
        EXPERIENCE_GREEN(8453920),
        AQUA(0x55FFFF),
        RED(0xFF5555),
        LIGHT_PURPLE(0xFF55FF),
        YELLOW(0xFFFF55),
        WHITE(0xFFFFFF);

        public final int color;

        private KnownColor(int color) {
            this.color = color;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum TimeFormat {
        RELATIVE,
        ABSOLUTE;

    }
}

