/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.feature.bosstimer;

import dev.eposs.elementsutils.api.timer.BossTimerApi;
import dev.eposs.elementsutils.util.TimerUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class BossTimerData {
    private String axolotl;
    private String zombie;
    private String spider;
    private String bogged;
    private String piglin;
    private static final AtomicReference<BossTimerData> INSTANCE = new AtomicReference<BossTimerData>(new BossTimerData());
    private static Instant lastUpdate = Instant.MIN;

    public static void startUpdateTimers() {
        new Timer("BossTimerData Update Timer").scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                BossTimerData.updateData();
            }
        }, 0L, Duration.ofHours(1L).toMillis());
    }

    public static void updateData() {
        if (lastUpdate.isAfter(Instant.now().minusSeconds(10L))) {
            return;
        }
        Thread.ofVirtual().name("BossTimerData Update Thread").start(() -> {
            lastUpdate = Instant.now();
            BossTimerData data = (BossTimerData)new BossTimerApi().getTimerData();
            if (data != null) {
                INSTANCE.set(data);
            }
        });
    }

    public static BossTimerData getInstance() {
        return INSTANCE.get();
    }

    public ZonedDateTime getAxolotl() {
        return TimerUtil.parseTime(this.axolotl);
    }

    public ZonedDateTime getZombie() {
        return TimerUtil.parseTime(this.zombie);
    }

    public ZonedDateTime getSpider() {
        return TimerUtil.parseTime(this.spider);
    }

    public ZonedDateTime getBogged() {
        return TimerUtil.parseTime(this.bogged);
    }

    public ZonedDateTime getPiglin() {
        return TimerUtil.parseTime(this.piglin);
    }
}

