/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.feature.bosstimer;

import dev.eposs.elementsutils.config.ModConfig;
import dev.eposs.elementsutils.feature.bosstimer.BossTimerData;
import dev.eposs.elementsutils.util.TimerUtil;
import java.time.Duration;
import java.time.ZonedDateTime;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class BossTimerDisplay {
    public static void toggleDisplay(@NotNull class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        ModConfig.getConfig().bossTimer.show = !ModConfig.getConfig().bossTimer.show;
        ModConfig.save();
        if (ModConfig.getConfig().bossTimer.show) {
            BossTimerData.updateData();
        }
    }

    public static void render(class_332 context, class_310 client) {
        ModConfig.BossTimerConfig config = ModConfig.getConfig().bossTimer;
        if (!config.show) {
            return;
        }
        BossTimerData timerData = BossTimerData.getInstance();
        BossTimerDisplay.drawText(client, context, 0, (class_2561)class_2561.method_43471((String)"elements-utils.display.bossTimer.title").method_27692(class_124.field_1073));
        BossTimerDisplay.drawText(client, context, 1, BossTimerDisplay.formattedText("Axolotl", class_124.field_1076, timerData.getAxolotl(), config));
        BossTimerDisplay.drawText(client, context, 2, BossTimerDisplay.formattedText("Zombie", class_124.field_1060, timerData.getZombie(), config));
        BossTimerDisplay.drawText(client, context, 3, BossTimerDisplay.formattedText("Spider", class_124.field_1063, timerData.getSpider(), config));
        BossTimerDisplay.drawText(client, context, 4, BossTimerDisplay.formattedText("Bogged", class_124.field_1077, timerData.getBogged(), config));
        BossTimerDisplay.drawText(client, context, 5, BossTimerDisplay.formattedText("Piglin", class_124.field_1061, timerData.getPiglin(), config));
    }

    private static class_2561 formattedText(String name, class_124 nameColor, ZonedDateTime time, ModConfig.BossTimerConfig config) {
        return class_2561.method_43470((String)"").method_10852((class_2561)TimerUtil.optionalFormattedText(class_2561.method_43470((String)(name + ": ")), config.colorBossNames, nameColor)).method_10852((class_2561)(time == null ? class_2561.method_43471((String)"elements-utils.unknown") : TimerUtil.optionalFormattedText(config.bossTimeFormat == ModConfig.TimeFormat.RELATIVE ? BossTimerDisplay.toRelativeTime(time) : class_2561.method_43470((String)time.format(TimerUtil.ABSOLUTE_TIME_FORMATTER)), config.colorBossTime, BossTimerDisplay.getTimeColor(time))));
    }

    private static class_124 getTimeColor(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return class_124.field_1068;
        }
        Duration duration = TimerUtil.getDuration(dateTime);
        if (duration.isNegative()) {
            return class_124.field_1068;
        }
        long hours = duration.toHours();
        if (hours >= 36L && hours < 48L) {
            return class_124.field_1054;
        }
        if (hours >= 48L) {
            return class_124.field_1061;
        }
        return class_124.field_1060;
    }

    private static class_5250 toRelativeTime(@NotNull ZonedDateTime dateTime) {
        Duration duration = TimerUtil.getDuration(dateTime);
        if (duration.isNegative()) {
            return class_2561.method_43471((String)"elements-utils.unknown");
        }
        return class_2561.method_43470((String)TimerUtil.toRelativeTime(duration));
    }

    private static void drawText(class_310 client, class_332 context, int line, class_2561 text) {
        boolean outline = ModConfig.getConfig().bossTimer.textOutline;
        TimerUtil.drawText(client, context, line, text, outline);
    }
}

