/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.feature.excaliburtimer;

import dev.eposs.elementsutils.api.timer.ExcaliburTimerApi;
import dev.eposs.elementsutils.util.TimerUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ExcaliburTimerData {
    private String next_user;
    private String time;
    private static final AtomicReference<ExcaliburTimerData> INSTANCE = new AtomicReference<ExcaliburTimerData>(new ExcaliburTimerData());
    private static Instant lastUpdate = Instant.MIN;

    public static void startUpdateTimers() {
        new Timer("ExcaliburTimerData Update Timer").scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ExcaliburTimerData.updateData();
            }
        }, 0L, Duration.ofHours(1L).toMillis());
    }

    public static void updateData() {
        if (lastUpdate.isAfter(Instant.now().minusSeconds(10L))) {
            return;
        }
        Thread.ofVirtual().name("ExcaliburTimerData Update Thread").start(() -> {
            lastUpdate = Instant.now();
            ExcaliburTimerData data = (ExcaliburTimerData)new ExcaliburTimerApi().getTimerData();
            if (data != null) {
                INSTANCE.set(data);
            }
        });
    }

    public static ExcaliburTimerData getInstance() {
        return INSTANCE.get();
    }

    public String getNextUser() {
        return this.next_user;
    }

    public ZonedDateTime getTime() {
        return TimerUtil.parseTime(this.time);
    }
}

