/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.feature.excaliburtimer;

import dev.eposs.elementsutils.config.ModConfig;
import dev.eposs.elementsutils.feature.excaliburtimer.ExcaliburTimerData;
import dev.eposs.elementsutils.util.TimerUtil;
import java.time.Duration;
import java.time.ZonedDateTime;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ExcaliburTimerDisplay {
    private static final int DAYS = 7;
    private static final long EXTRA_SECONDS = 140L;

    public static void toggleDisplay(@NotNull class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        ModConfig.getConfig().excaliburTime.show = !ModConfig.getConfig().excaliburTime.show;
        ModConfig.save();
        if (ModConfig.getConfig().excaliburTime.show) {
            ExcaliburTimerData.updateData();
        }
    }

    public static void render(class_332 context, class_310 client, int baseLine) {
        ModConfig.ExcaliburTimeConfig config = ModConfig.getConfig().excaliburTime;
        if (!config.show) {
            return;
        }
        ExcaliburTimerData data = ExcaliburTimerData.getInstance();
        ZonedDateTime targetTime = ExcaliburTimerDisplay.calculateTargetTime(data.getTime());
        Duration timeUntilTarget = targetTime == null ? Duration.ZERO : Duration.between(ZonedDateTime.now(), targetTime);
        ExcaliburTimerDisplay.drawText(client, context, baseLine, (class_2561)class_2561.method_43471((String)"elements-utils.display.excaliburTime.title").method_27692(class_124.field_1073));
        ExcaliburTimerDisplay.drawText(client, context, baseLine + 1, (class_2561)class_2561.method_43470((String)"").method_10852((class_2561)TimerUtil.optionalFormattedText(class_2561.method_43471((String)"elements-utils.display.excaliburTime.next_player"), config.colorExcaliburNames, class_124.field_1061)).method_10852((class_2561)TimerUtil.optionalFormattedText(data.getNextUser().isEmpty() ? class_2561.method_43471((String)"elements-utils.unknown") : class_2561.method_43470((String)data.getNextUser()), config.colorExcaliburNames, class_124.field_1065)));
        ExcaliburTimerDisplay.drawText(client, context, baseLine + 2, (class_2561)class_2561.method_43470((String)"").method_10852((class_2561)TimerUtil.optionalFormattedText(class_2561.method_43471((String)"elements-utils.display.excaliburTime.time_left"), config.colorExcaliburTime, class_124.field_1075)).method_10852((class_2561)(config.excaliburTimeFormat == ModConfig.TimeFormat.RELATIVE ? ExcaliburTimerDisplay.toRelativeTime(timeUntilTarget) : (targetTime == null ? class_2561.method_43471((String)"elements-utils.unknown") : TimerUtil.optionalFormattedText(class_2561.method_43470((String)TimerUtil.ABSOLUTE_TIME_FORMATTER.format(targetTime)), config.colorExcaliburTime, class_124.field_1060)))));
    }

    private static class_2561 toRelativeTime(Duration duration) {
        String timeString = TimerUtil.toRelativeTime(duration.abs());
        String key = duration.isNegative() ? "elements-utils.display.excaliburTime.relative_after" : "elements-utils.display.excaliburTime.relative";
        return TimerUtil.optionalFormattedText(class_2561.method_43469((String)key, (Object[])new Object[]{timeString}), ModConfig.getConfig().excaliburTime.colorExcaliburTime, class_124.field_1060);
    }

    private static ZonedDateTime calculateTargetTime(ZonedDateTime startTime) {
        if (startTime == null) {
            return null;
        }
        return startTime.plusDays(7L).plusSeconds(140L);
    }

    private static void drawText(class_310 client, class_332 context, int line, class_2561 text) {
        boolean outline = ModConfig.getConfig().excaliburTime.textOutline;
        TimerUtil.drawText(client, context, line, text, outline);
    }
}

