/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.feature.pet;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.eposs.elementsutils.ElementsUtils;
import dev.eposs.elementsutils.config.ModConfig;
import dev.eposs.elementsutils.rendering.Position;
import dev.eposs.elementsutils.rendering.ScreenPositioning;
import dev.eposs.elementsutils.util.Util;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_476;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5626;
import net.minecraft.class_7225;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class PetDisplay {
    private static class_1799 pet = class_1799.field_8037;
    private static String petNbtData;
    private static int currentXP;
    private static int nextLvlXP;

    public static void updatePetXP(class_2561 text, boolean fromTooltip) {
        String startText = fromTooltip ? "Pet XP: " : "Pet: ";
        String slashText = fromTooltip ? " / " : "/";
        String msg = text.getString();
        if (!msg.contains(startText)) {
            return;
        }
        int start = msg.indexOf(startText);
        int slash = msg.indexOf(slashText, start);
        int end = msg.indexOf(" XP", slash);
        try {
            String currentXpStr = msg.substring(start + startText.length(), slash).replaceAll("[.,]", "");
            String nextLvlXpStr = msg.substring(slash + slashText.length(), fromTooltip ? msg.length() : end).replaceAll("[.,]", "");
            currentXP = Integer.parseInt(currentXpStr);
            nextLvlXP = Integer.parseInt(nextLvlXpStr);
        }
        catch (Exception e) {
            ElementsUtils.LOGGER.debug("Failed to parse pet XP");
        }
    }

    public static void updatePet(class_310 client) {
        class_1799 checkStack;
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_476 enderChestScreen = Util.getEnderChestScreen();
        if (enderChestScreen == null) {
            return;
        }
        class_1707 screenHandler = (class_1707)enderChestScreen.method_17577();
        class_1735 checkSlot = (class_1735)screenHandler.field_7761.get(4);
        class_1735 petSlot = (class_1735)screenHandler.field_7761.get(13);
        if (checkSlot.method_7681() && petSlot.method_7681() && (checkStack = checkSlot.method_7677()).method_7909() == class_1802.field_40229 && checkStack.method_7964().getString().equals("Pets")) {
            class_1799 petStack = petSlot.method_7677();
            if (pet == petStack) {
                return;
            }
            if (petStack.method_7909() == class_1802.field_8575) {
                pet = petStack;
                List tooltip = petStack.method_7950(class_1792.class_9635.field_51353, (class_1657)client.field_1724, (class_1836)class_1836.field_41070);
                tooltip.stream().filter(text -> text.getString().contains("Pet XP:")).findFirst().ifPresent(text -> PetDisplay.updatePetXP(text, true));
                petNbtData = new class_5626().method_32288(pet.method_57358((class_7225.class_7874)client.field_1687.method_30349()));
            } else {
                pet = class_1799.field_8037;
                petNbtData = null;
                currentXP = 0;
                nextLvlXP = 0;
            }
        }
    }

    public static void render(class_332 context, class_310 client) {
        if (!ModConfig.getConfig().showPetDisplay) {
            return;
        }
        if (pet.method_7960()) {
            class_5250 noPet = class_2561.method_43471((String)"elements-utils.display.pet.no_pet");
            int textLength = client.field_1772.method_27525((class_5348)noPet);
            ScreenPositioning.PET_WIDTH = textLength + 12;
            Position position = ScreenPositioning.getPetPosition(client.method_22683());
            context.method_51439(client.field_1772, (class_2561)noPet, position.x() + 6, position.y() + 12, -1, false);
            return;
        }
        String levelText = "Level " + PetDisplay.getPetLevel();
        int textLength = Math.max(client.field_1772.method_27525((class_5348)pet.method_7964()), client.field_1772.method_1727(levelText));
        ScreenPositioning.PET_WIDTH = textLength + 32 + 6;
        Position position = ScreenPositioning.getPetPosition(client.method_22683());
        PetDisplay.renderCircle(context, new Position(position.x() + 16, position.y() + 16));
        context.method_51427(pet, position.x() + 8, position.y() + 8);
        context.method_51439(client.field_1772, pet.method_7964(), position.x() + 32, position.y() + 6, -1, false);
        context.method_51433(client.field_1772, levelText, position.x() + 32, position.y() + 6 + 8 + 4, -1, false);
    }

    private static void renderCircle(@NotNull class_332 context, @NotNull Position centerPosition) {
        int segments = 64;
        float innerRadius = 10.0f;
        float outerRadius = 12.0f;
        float centerX = centerPosition.x();
        float centerY = centerPosition.y();
        Matrix4f transformationMatrix = context.method_51448().method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (int i = 0; i < segments; ++i) {
            float angle = (float)(Math.PI * (double)(2.0f * (float)i / (float)segments + 1.5f));
            float angleNext = (float)(Math.PI * (double)(2.0f * (float)(i + 1) / (float)segments + 1.5f));
            float outerX1 = centerX + class_3532.method_15362((float)angle) * outerRadius;
            float outerY1 = centerY + class_3532.method_15374((float)angle) * outerRadius;
            float outerX2 = centerX + class_3532.method_15362((float)angleNext) * outerRadius;
            float outerY2 = centerY + class_3532.method_15374((float)angleNext) * outerRadius;
            float innerX1 = centerX + class_3532.method_15362((float)angle) * innerRadius;
            float innerY1 = centerY + class_3532.method_15374((float)angle) * innerRadius;
            float innerX2 = centerX + class_3532.method_15362((float)angleNext) * innerRadius;
            float innerY2 = centerY + class_3532.method_15374((float)angleNext) * innerRadius;
            int color = -16711936;
            if (nextLvlXP > 0 && (float)i / (float)segments > (float)currentXP / (float)nextLvlXP) {
                color = -6250336;
            }
            buffer.method_22918(transformationMatrix, innerX1, innerY1, 0.0f).method_39415(color);
            buffer.method_22918(transformationMatrix, innerX2, innerY2, 0.0f).method_39415(color);
            buffer.method_22918(transformationMatrix, outerX2, outerY2, 0.0f).method_39415(color);
            buffer.method_22918(transformationMatrix, outerX1, outerY1, 0.0f).method_39415(color);
        }
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    private static int getPetLevel() {
        if (nextLvlXP == 5000) {
            return 1;
        }
        if (nextLvlXP == 20000) {
            return 2;
        }
        if (nextLvlXP == 50000) {
            return 3;
        }
        if (nextLvlXP == 100000) {
            return 4;
        }
        if (nextLvlXP == 200000) {
            return 5;
        }
        if (nextLvlXP == 350000) {
            return 6;
        }
        if (nextLvlXP == 550000) {
            return 7;
        }
        if (nextLvlXP == 750000) {
            return 8;
        }
        if (nextLvlXP == 1000000) {
            return 9;
        }
        if (nextLvlXP == -1) {
            return 10;
        }
        return 0;
    }

    public static void savePet() {
        ElementsUtils.LOGGER.info("Saving Pet Data...");
        ModConfig.InternalConfig.PetData petData = new ModConfig.InternalConfig.PetData();
        petData.data = petNbtData;
        petData.currentXP = currentXP;
        petData.nextLvlXP = nextLvlXP;
        ModConfig.getConfig().internal.petData = petData;
        ModConfig.save();
    }

    public static void loadPet(class_7225.class_7874 registry) {
        ElementsUtils.LOGGER.info("Loading pet data...");
        ModConfig.InternalConfig.PetData petData = ModConfig.getConfig().internal.petData;
        try {
            pet = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)class_2522.method_10718((String)petData.data));
        }
        catch (Exception e) {
            ElementsUtils.LOGGER.error("Failed to parse pet data. Error: {}", (Object)e.getMessage());
            return;
        }
        petNbtData = petData.data;
        currentXP = petData.currentXP;
        nextLvlXP = petData.nextLvlXP;
    }

    public static void setPetMaxLevel() {
        nextLvlXP = -1;
    }

    static {
        currentXP = 0;
        nextLvlXP = 0;
    }
}

