/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.feature.playerbase;

import dev.eposs.elementsutils.config.ModConfig;
import dev.eposs.elementsutils.util.Util;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class BaseBorderDisplay {
    public static void toggleDisplay(@NotNull class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        ModConfig.getConfig().showBaseDisplay = !ModConfig.getConfig().showBaseDisplay;
        ModConfig.save();
        Util.sendChatMessage((class_2561)class_2561.method_43471((String)"elements-utils.display.base.toggle").method_10852((class_2561)(ModConfig.getConfig().showBaseDisplay ? class_2561.method_43471((String)"elements-utils.enabled").method_27692(class_124.field_1060) : class_2561.method_43471((String)"elements-utils.disabled").method_27692(class_124.field_1061))));
    }

    public static void render(WorldRenderContext context) {
        ModConfig config = ModConfig.getConfig();
        if (!config.showBaseDisplay) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_638 world = client.field_1687;
        ArrayList<class_1646> villagers = new ArrayList<class_1646>();
        for (class_1297 entity : world.method_18112()) {
            class_2561 customName;
            class_1799 offHandStack;
            if (!(entity instanceof class_1646)) continue;
            class_1646 villager = (class_1646)entity;
            if (!config.devUtils.enable && ((offHandStack = villager.method_6079()) == null || offHandStack.method_7909() != class_1802.field_8091 || (customName = offHandStack.method_65130()) == null)) continue;
            villagers.add(villager);
        }
        if (villagers.isEmpty()) {
            return;
        }
        class_4587 matrices = context.matrixStack();
        assert (matrices != null);
        class_243 camPos = context.camera().method_19326();
        int radius = 45;
        int stacks = 32;
        int sectors = 64;
        for (class_1646 villager : villagers) {
            class_243 pos = villager.method_19538();
            matrices.method_22903();
            class_243 target = new class_243(pos.field_1352, pos.field_1351, pos.field_1350).method_1020(camPos);
            class_4597.class_4598 vcp = (class_4597.class_4598)context.consumers();
            assert (vcp != null);
            BaseBorderDisplay.renderSolidSphere(matrices, vcp, target, radius, stacks, sectors);
            matrices.method_22909();
            vcp.method_22993();
        }
    }

    private static void renderSolidSphere(class_4587 matrices, class_4597.class_4598 vertexConsumers, class_243 center, float radius, int stacks, int sectors) {
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)class_2960.method_60654((String)"textures/misc/white.png")));
        for (int i = 0; i < stacks; ++i) {
            float phi1 = (float)(Math.PI * (double)i / (double)stacks);
            float phi2 = (float)(Math.PI * (double)(i + 1) / (double)stacks);
            for (int j = 0; j < sectors; ++j) {
                float theta1 = (float)(Math.PI * 2 * (double)j / (double)sectors);
                float theta2 = (float)(Math.PI * 2 * (double)(j + 1) / (double)sectors);
                float x1 = (float)((double)radius * Math.sin(phi1) * Math.cos(theta1));
                float y1 = (float)((double)radius * Math.cos(phi1));
                float z1 = (float)((double)radius * Math.sin(phi1) * Math.sin(theta1));
                float x2 = (float)((double)radius * Math.sin(phi2) * Math.cos(theta1));
                float y2 = (float)((double)radius * Math.cos(phi2));
                float z2 = (float)((double)radius * Math.sin(phi2) * Math.sin(theta1));
                float x3 = (float)((double)radius * Math.sin(phi2) * Math.cos(theta2));
                float y3 = (float)((double)radius * Math.cos(phi2));
                float z3 = (float)((double)radius * Math.sin(phi2) * Math.sin(theta2));
                float x4 = (float)((double)radius * Math.sin(phi1) * Math.cos(theta2));
                float y4 = (float)((double)radius * Math.cos(phi1));
                float z4 = (float)((double)radius * Math.sin(phi1) * Math.sin(theta2));
                x1 += (float)center.field_1352;
                y1 += (float)center.field_1351;
                z1 += (float)center.field_1350;
                x2 += (float)center.field_1352;
                y2 += (float)center.field_1351;
                z2 += (float)center.field_1350;
                x3 += (float)center.field_1352;
                BaseBorderDisplay.vertex(vertexConsumer, positionMatrix, x1, y1, z1);
                BaseBorderDisplay.vertex(vertexConsumer, positionMatrix, x2, y2, z2);
                BaseBorderDisplay.vertex(vertexConsumer, positionMatrix, x3, y3 += (float)center.field_1351, z3 += (float)center.field_1350);
                BaseBorderDisplay.vertex(vertexConsumer, positionMatrix, x4 += (float)center.field_1352, y4 += (float)center.field_1351, z4 += (float)center.field_1350);
            }
        }
    }

    private static void vertex(class_4588 vc, Matrix4f matrix, float x, float y, float z) {
        vc.method_22918(matrix, x, y, z).method_1336(0, 255, 0, 128).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_22914(0.0f, 1.0f, 0.0f);
    }
}

