/*
 * Decompiled with CFR 0.152.
 */
package dev.eposs.elementsutils.feature.potion;

import dev.eposs.elementsutils.config.ModConfig;
import dev.eposs.elementsutils.rendering.Position;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class PotionDisplay {
    private static int smallHeal = 0;
    private static int bigHeal = 0;
    private static int smallMana = 0;
    private static int bigMana = 0;

    public static void updatePotions(class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        smallHeal = 0;
        bigHeal = 0;
        smallMana = 0;
        bigMana = 0;
        class_2371 stacks = client.field_1724.method_31548().field_7547;
        stacks.stream().filter(stack -> !stack.method_7960() && stack.method_7909() == class_1802.field_8574).forEach(stack -> {
            class_9279 customData = (class_9279)stack.method_57353().method_57829(class_9334.field_49628);
            if (customData != null) {
                String tag = customData.method_57461().method_10558("tag");
                int count = stack.method_7947();
                switch (tag) {
                    case "heal_potion_small": {
                        smallHeal += count;
                        break;
                    }
                    case "heal_potion_big": {
                        bigHeal += count;
                        break;
                    }
                    case "mana_potion_small": {
                        smallMana += count;
                        break;
                    }
                    case "mana_potion_big": {
                        bigMana += count;
                    }
                }
            }
        });
    }

    public static void render(class_332 context, class_310 client) {
        if (!ModConfig.getConfig().potionDisplay.show) {
            return;
        }
        int start = 100;
        int gap = 20;
        int y = context.method_51443() - 25;
        switch (ModConfig.getConfig().potionDisplay.position) {
            case LEFT: {
                start = context.method_51421() / 2 - 200;
                break;
            }
            case RIGHT: {
                start = context.method_51421() / 2 + 200 - gap * 4;
            }
        }
        PotionDisplay.draw(context, client.field_1772, "small_heal.png", smallHeal, new Position(start, y));
        PotionDisplay.draw(context, client.field_1772, "big_heal.png", bigHeal, new Position(start + gap, y));
        PotionDisplay.draw(context, client.field_1772, "small_mana.png", smallMana, new Position(start + gap * 2, y));
        PotionDisplay.draw(context, client.field_1772, "big_mana.png", bigMana, new Position(start + gap * 3, y));
    }

    private static void draw(class_332 context, class_327 textRenderer, String texture, int count, Position position) {
        int size = 16;
        context.method_25290(class_1921::method_62277, class_2960.method_60655((String)"elements-utils", (String)("gui/containers/" + texture)), position.x(), position.y(), 0.0f, 0.0f, size, size, size, size);
        String countString = String.valueOf(count);
        context.method_51433(textRenderer, countString, position.x() + size - textRenderer.method_1727(countString), position.y() + size, -1, false);
    }
}

